/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.im.traveldocs;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.railway.RailwayMcoProduct;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.util.PersonalName;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.common.traveldocs.RailwayTravelDocParameters;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IBusIMContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.stream.Collectors;

public class IMGetMcoBlankResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) {
        RailwayMcoProduct mcoProduct = (RailwayMcoProduct)ctx.getMandatoryObject((Enum)IBusIMContextKeys.IM_RAILWAY_PRODUCT);
        byte[] response = (byte[])ctx.getMandatoryObject((Enum)IBusIMContextKeys.IM_RESPONSE_DATA);
        if (response == null) {
            throw Xeption.forAdmin((String)"\u0414\u043b\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 %s \u0431\u043b\u0430\u043d\u043a \u043d\u0435 \u0441\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d.", (Object[])new Object[]{mcoProduct.getSystemNumber()});
        }
        DocumentType documentType = DocumentType.MCO_DOCUMENT;
        ContentType contentType = ContentType.PDF;
        ctx.putObject((Enum)IBusRailwayContextKeys.RAILWAY_TRAVELDOC_PARAMS, (Object)new RailwayTravelDocParameters(this.getTravelDocumentTitle(mcoProduct), response, contentType, documentType, mcoProduct.getUid()));
    }

    private String getTravelDocumentTitle(RailwayMcoProduct mcoProduct) {
        String documentType = mcoProduct.getStatus() == ProductStatus.REFUND ? "\u041a\u0420\u0421 (\u0431\u0430\u0433\u0430\u0436)" : "\u0416\u0414 \u043a\u0432\u0438\u0442\u0430\u043d\u0446\u0438\u044f (\u0431\u0430\u0433\u0430\u0436)";
        return String.format("%s %s - %s", documentType, mcoProduct.getSystemNumber(), this.buildPassengerNames(mcoProduct));
    }

    private String buildPassengerNames(RailwayMcoProduct railwayProduct) {
        return railwayProduct.getPassengers().stream().map(traveller -> TextUtil.buildFullName((PersonalName)traveller.getPassport())).filter(TextUtil::nonBlank).collect(Collectors.joining(", "));
    }
}

