/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.im.traveldocs;

import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.util.PersonalName;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IBusIMContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IMHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.traveldocs.IMRailwayGetTicketBlankParameters;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.stream.Collectors;

public class IMRailwayGetTicketBlankParamsBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        RailwayProduct railwayProduct = (RailwayProduct)ctx.getMandatoryObject((Enum)IBusIMContextKeys.IM_RAILWAY_PRODUCT);
        ctx.putObject((Enum)IBusRailwayContextKeys.RAILWAY_GET_TICKET_BLANK_PARAMS, (Object)this.createTicketBlankParameters(railwayProduct));
    }

    private IMRailwayGetTicketBlankParameters createTicketBlankParameters(RailwayProduct railwayProduct) {
        String orderItemId = IMHelper.getOrderItemId(railwayProduct, true);
        String orderItemBlankId = railwayProduct.getBlankId();
        return new IMRailwayGetTicketBlankParameters(orderItemId, orderItemBlankId, this.getTravelDocumentTitle(railwayProduct), DocumentType.TRAVELDOCUMENT, railwayProduct.getUid());
    }

    private String getTravelDocumentTitle(RailwayProduct railwayProduct) {
        String documentType = railwayProduct.getStatus() == ProductStatus.REFUND ? "\u041a\u0420\u0421" : "\u0416\u0414 \u0411\u0438\u043b\u0435\u0442";
        return String.format("%s %s - %s", documentType, railwayProduct.getSystemNumber(), this.buildPassengerNames(railwayProduct));
    }

    private String buildPassengerNames(RailwayProduct railwayProduct) {
        return railwayProduct.getPassengers().stream().map(traveller -> TextUtil.buildFullName((PersonalName)traveller.getPassport())).filter(TextUtil::nonBlank).collect(Collectors.joining(", "));
    }
}

