/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.kz;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.system.HttpResponse;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.exception.UnauthorizedException;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;

public abstract class KzAbstractHttpResponseParser
extends BaseProcessor {
    protected void checkResponse(HttpResponse response) {
        this.checkResponse(response, false);
    }

    protected void checkResponse(HttpResponse response, boolean ignoreError) {
        if (response.getBody() != null) {
            return;
        }
        if (response.getResponseCode() == 401) {
            throw new UnauthorizedException();
        }
        if (ignoreError && response.getError() != null) {
            return;
        }
        if (response.getError() != null) {
            String errorContent = new String(response.getError());
            throw Xeption.forDeveloper((String)"error: {0}", (Object[])new Object[]{errorContent});
        }
        if (response.getResponseCode() == 204) {
            return;
        }
        throw Xeption.forDeveloper((String)"response is null, code = {0}, message = {1}", (Object[])new Object[]{response.getResponseCode(), response.getResponseMessage()});
    }
}

