/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.kz;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import com.gridnine.xtrip.common.ibecorp.model.KzRailGdsAccount;
import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.ibecorp.rzd.model.KupeIndication;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.midoffice.helper.CodeTranslator;
import com.gridnine.xtrip.common.midoffice.helper.ReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.railway.CarriageType;
import com.gridnine.xtrip.common.model.booking.railway.CompartmentType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.ServiceClass;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.KzOperation;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.KzRequestParameters;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.model.BuyRQ;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.model.BuyRS;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.model.GetOrderStatusRS;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.model.common.ClassService;
import com.gridnine.xtrip.server.railway.model.helpers.RzdServiceConverter;
import java.io.ByteArrayInputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Signature;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class KzHelper {
    private static final DateTimeFormatter LOCAL_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");
    private static final DateTimeFormatter LOCAL_TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss");
    public static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE, true).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).registerModule((Module)new JavaTimeModule().addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(LOCAL_DATE_TIME_FORMATTER)).addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(LOCAL_DATE_TIME_FORMATTER)).addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(LOCAL_TIME_FORMATTER)).addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer(LOCAL_TIME_FORMATTER)));
    private static final CodeTranslator translator = new CodeTranslator(new String[]{CodeSystem.EXPRESS.name()});
    private static final Map<Integer, CarriageType> carriageTypeMap = new HashMap<Integer, CarriageType>();
    private static final Map<String, CarriageType> carriageTypeStrMap;
    private static final Map<KupeIndication, BuyRQ.SeatsComp> kupeIndicationMap;
    private static final Map<CompartmentType, BuyRQ.CompType> compartmentTypeMap;
    private static final Map<Gender, BuyRQ.Sex> genderMap;
    private static final Map<PassportType, MiscUtil.Pair<Integer, String>> passportTypeMap;
    private static final MiscUtil.Pair<Integer, String> KZ_PASSPORT_TYPE_PAIR;
    private static final MiscUtil.Pair<Integer, String> UZ_PASSPORT_TYPE_PAIR;
    private static final String BLANK_ID_SEPARATOR = "/";

    public static String buildUrl(KzRequestParameters reqParams, KzRailGdsAccount gdsAccount) throws Exception {
        KzOperation operation = reqParams.getOperation();
        String address = operation == KzOperation.GetToken ? gdsAccount.getGetTokenAddress() : gdsAccount.getMainAddress();
        StringBuilder sb = new StringBuilder(address);
        sb.append(operation.getUrlSuffix());
        LinkedHashMap<String, String> urlParameters = new LinkedHashMap<String, String>();
        if (reqParams.getUrlParameters() != null) {
            urlParameters.putAll(reqParams.getUrlParameters());
        }
        if (operation.isNeedMachineKey()) {
            urlParameters.put("machineKey", gdsAccount.getMachineKey());
        }
        if (!urlParameters.isEmpty()) {
            sb.append("?").append(KzHelper.buildUrlParametersString(urlParameters));
        }
        return sb.toString();
    }

    private static String buildUrlParametersString(Map<String, String> urlParameters) throws Exception {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : urlParameters.entrySet()) {
            if (sb.length() != 0) {
                sb.append("&");
            }
            sb.append(entry.getKey()).append("=").append(entry.getValue() == null ? "" : URLEncoder.encode(entry.getValue(), "UTF-8"));
        }
        return sb.toString();
    }

    public static String getOrderId(Reservation reservation) {
        return ReservationGdsNameInfoHelper.getOnlineRecordLocator((Reservation)reservation, (RecordLocatorType)RecordLocatorType.DEFAULT);
    }

    public static <D extends BaseDictionary> String getNativeCode(DictionaryReference<D> dictRef) {
        return translator.getNativeCode(dictRef);
    }

    public static <D extends BaseDictionary> DictionaryReference<D> resolveNativeCode(Class<D> cls, String code) {
        return translator.resolveNativeCode(cls, code);
    }

    public static CarriageType convertCarriageTypeFromGds(Integer value) {
        return carriageTypeMap.get(value);
    }

    public static Integer convertCarriageTypeToGds(CarriageType value) {
        return (Integer)CollectionUtil.getKeyByValue(carriageTypeMap, (Object)value);
    }

    public static CarriageType convertCarriageTypeFromGds(String value) {
        return carriageTypeStrMap.get(value);
    }

    public static BuyRQ.SeatsComp convertKupeIndicationToGds(KupeIndication value) {
        return kupeIndicationMap.get(value);
    }

    public static BuyRQ.CompType convertCompartmentTypeToGds(CompartmentType value) {
        return compartmentTypeMap.get(value);
    }

    public static BuyRQ.Sex convertGenderToGds(Gender value) {
        return genderMap.get(value);
    }

    public static Collection<PassportType> getAvailablePassportTypes() {
        return passportTypeMap.keySet();
    }

    private static MiscUtil.Pair<Integer, String> getPassportTypePair(PassportType passportType, DictionaryReference<Country> citizenship) {
        if (passportType == PassportType.PASSPORT) {
            if (RzdCommonHelper.isKzCitizenship(citizenship)) {
                return KZ_PASSPORT_TYPE_PAIR;
            }
            if (RzdCommonHelper.isUzCitizenship(citizenship)) {
                return UZ_PASSPORT_TYPE_PAIR;
            }
        }
        return passportTypeMap.get(passportType);
    }

    public static Integer convertPassportTypeToGdsInt(PassportType value, DictionaryReference<Country> citizenship) {
        MiscUtil.Pair<Integer, String> pair = KzHelper.getPassportTypePair(value, citizenship);
        return pair == null ? null : (Integer)pair.getFirst();
    }

    public static String convertPassportTypeToGdsStr(PassportType value, DictionaryReference<Country> citizenship) {
        MiscUtil.Pair<Integer, String> pair = KzHelper.getPassportTypePair(value, citizenship);
        return pair == null ? null : (String)pair.getSecond();
    }

    public static PassportType convertPassportTypeFromGdsStr(String value) {
        if (TextUtil.isBlank((String)value)) {
            return null;
        }
        if (KzHelper.isEqualsPassportTypePair(value, KZ_PASSPORT_TYPE_PAIR)) {
            return PassportType.PASSPORT;
        }
        if (KzHelper.isEqualsPassportTypePair(value, UZ_PASSPORT_TYPE_PAIR)) {
            return PassportType.PASSPORT;
        }
        for (Map.Entry<PassportType, MiscUtil.Pair<Integer, String>> entry : passportTypeMap.entrySet()) {
            if (!KzHelper.isEqualsPassportTypePair(value, entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    private static boolean isEqualsPassportTypePair(String value, MiscUtil.Pair<Integer, String> passportTypePair) {
        return MiscUtil.equals((Object)value, (Object)passportTypePair.getSecond());
    }

    public static ProductStatus convertToProductStatus(GetOrderStatusRS.TicketState state) {
        switch (state) {
            case Cancelled: {
                return ProductStatus.VOID_BOOKING;
            }
            case PaymentConfirmed: 
            case PaymentConfirmedElReg: 
            case BoardingPass: {
                return ProductStatus.SELL;
            }
            case Returned: {
                return ProductStatus.REFUND;
            }
        }
        return null;
    }

    public static Integer calcMinutes(String durationStr) {
        LocalTime time;
        if (TextUtil.isBlank((String)durationStr)) {
            return null;
        }
        String[] durationParts = durationStr.split("\\.");
        int days = 0;
        if (durationParts.length == 1) {
            time = LocalTime.parse(durationParts[0]);
        } else if (durationParts.length == 2) {
            days = Integer.parseInt(durationParts[0]);
            time = LocalTime.parse(durationParts[1]);
        } else {
            throw Xeption.forDeveloper((String)"unsupported duration format: {0}", (Object[])new Object[]{durationStr});
        }
        return (days * 24 + time.getHour()) * 60 + time.getMinute();
    }

    public static Date convertZonedDateFromGds(LocalDateTime gdsDate, KzRailGdsAccount gdsAccount) {
        ZoneId zoneId = DateUtils.utcOffsetHoursToZoneId((int)6);
        TimeZone timeZone = MiscUtil.convertToTimeZone((String)gdsAccount.getTimeZoneId());
        if (timeZone != null) {
            zoneId = timeZone.toZoneId();
        }
        return DateUtils.toJavaDate((ZonedDateTime)ZonedDateTime.of(gdsDate, zoneId));
    }

    public static ServiceClass getServiceClass(ClassService classService) {
        ServiceClass serviceClass = RzdServiceConverter.getServiceClassByName((String)classService.getType());
        if (serviceClass == null) {
            IncidentsLog.reportStackTrace((String)("no railway serviceClass for " + classService.getType()));
        }
        return serviceClass;
    }

    public static Communication getPhoneCommunication(Traveller traveller) {
        return ProfileHelper.getPhoneCommunication((List)traveller.getCommunications());
    }

    public static String buildBlankId(BuyRS.Ticket gdsTicket) {
        return KzHelper.buildBlankId(gdsTicket.getId(), gdsTicket.getTicketId());
    }

    public static String buildBlankId(String gdsId, String gdsTicketId) {
        return Stream.of(gdsId, gdsTicketId).collect(Collectors.joining(BLANK_ID_SEPARATOR));
    }

    public static String getGdsId(String blankId) {
        return blankId.split(BLANK_ID_SEPARATOR)[0];
    }

    public static String getGdsTicketId(String blankId) {
        return blankId.split(BLANK_ID_SEPARATOR)[1];
    }

    public static byte[] calcSignature(String content, KzRailGdsAccount gdsAccount) throws Exception {
        if (gdsAccount.getP12file() == null) {
            return null;
        }
        char[] p12psw = gdsAccount.getP12password().toCharArray();
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        keyStore.load(new ByteArrayInputStream(gdsAccount.getP12file()), p12psw);
        String p12alias = keyStore.aliases().nextElement();
        PrivateKey privateKey = (PrivateKey)keyStore.getKey(p12alias, p12psw);
        Signature signature = Signature.getInstance("SHA1withRSA");
        signature.initSign(privateKey);
        signature.update(KzHelper.sha1(content));
        return signature.sign();
    }

    private static byte[] sha1(String text) throws Exception {
        MessageDigest mDigest = MessageDigest.getInstance("SHA-1");
        return mDigest.digest(text.getBytes(StandardCharsets.UTF_16LE));
    }

    public static boolean hasEmptyRefundTransId(List<RailwayProduct> products) {
        return products.stream().map(RailwayProduct::getRefundTransId).anyMatch(TextUtil::isBlank);
    }

    public static void checkAddress(String address) {
        if (TextUtil.isBlank((String)address)) {
            throw Xeption.forAdmin((String)"\u041d\u0435 \u0437\u0430\u0434\u0430\u043d URL", (Object[])new Object[0]);
        }
    }

    static {
        carriageTypeMap.put(1, CarriageType.O);
        carriageTypeMap.put(2, CarriageType.S);
        carriageTypeMap.put(3, CarriageType.P);
        carriageTypeMap.put(4, CarriageType.K);
        carriageTypeMap.put(5, CarriageType.M);
        carriageTypeMap.put(6, CarriageType.L);
        carriageTypeStrMap = new HashMap<String, CarriageType>();
        carriageTypeStrMap.put("\u0421\u0438\u0434\u044f\u0447\u0438\u0439", CarriageType.S);
        carriageTypeStrMap.put("\u041e\u0431\u0449\u0438\u0439", CarriageType.O);
        carriageTypeStrMap.put("\u041f\u043b\u0430\u0446\u043a\u0430\u0440\u0442\u043d\u044b\u0439", CarriageType.P);
        carriageTypeStrMap.put("\u041a\u0443\u043f\u0435", CarriageType.K);
        carriageTypeStrMap.put("\u041b\u044e\u043a\u0441", CarriageType.L);
        carriageTypeStrMap.put("\u041c\u044f\u0433\u043a\u0438\u0439", CarriageType.M);
        kupeIndicationMap = new HashMap<KupeIndication, BuyRQ.SeatsComp>();
        kupeIndicationMap.put(KupeIndication.ANY, null);
        kupeIndicationMap.put(KupeIndication.ONE_KUPE, BuyRQ.SeatsComp.ONE_KUPE);
        kupeIndicationMap.put(KupeIndication.ANY_KUPE, BuyRQ.SeatsComp.ONE_KUPE);
        kupeIndicationMap.put(KupeIndication.ONE_SECTION, BuyRQ.SeatsComp.ONE_SECTION);
        compartmentTypeMap = new HashMap<CompartmentType, BuyRQ.CompType>();
        compartmentTypeMap.put(CompartmentType.MEN, BuyRQ.CompType.MALE);
        compartmentTypeMap.put(CompartmentType.WOMEN, BuyRQ.CompType.FEMAIE);
        compartmentTypeMap.put(CompartmentType.COMMON, BuyRQ.CompType.MIXED);
        genderMap = new HashMap<Gender, BuyRQ.Sex>();
        genderMap.put(Gender.MALE, BuyRQ.Sex.MALE);
        genderMap.put(Gender.FEMALE, BuyRQ.Sex.FEMAIE);
        passportTypeMap = new LinkedHashMap<PassportType, MiscUtil.Pair<Integer, String>>();
        KZ_PASSPORT_TYPE_PAIR = MiscUtil.Pair.of((Object)0, (Object)"\u041f\u041a");
        UZ_PASSPORT_TYPE_PAIR = MiscUtil.Pair.of((Object)3, (Object)"\u041f\u0423");
        passportTypeMap.put(PassportType.INTERNAL, (MiscUtil.Pair<Integer, String>)MiscUtil.Pair.of((Object)1, (Object)"\u041f\u041d"));
        passportTypeMap.put(PassportType.FOREIGN, (MiscUtil.Pair<Integer, String>)MiscUtil.Pair.of((Object)2, (Object)"\u0417\u041f"));
        passportTypeMap.put(PassportType.IDENTITYCARD, (MiscUtil.Pair<Integer, String>)MiscUtil.Pair.of((Object)4, (Object)"\u0423\u041b"));
        passportTypeMap.put(PassportType.BIRTHDAY_NOTIFICATION, (MiscUtil.Pair<Integer, String>)MiscUtil.Pair.of((Object)5, (Object)"\u0421\u0420"));
        passportTypeMap.put(PassportType.MILITARYID, (MiscUtil.Pair<Integer, String>)MiscUtil.Pair.of((Object)6, (Object)"\u0412\u0411"));
        passportTypeMap.put(PassportType.PASSPORT, (MiscUtil.Pair<Integer, String>)MiscUtil.Pair.of((Object)7, (Object)"\u0417\u0417"));
        passportTypeMap.put(PassportType.INTERIMCERTIFICATE, (MiscUtil.Pair<Integer, String>)MiscUtil.Pair.of((Object)9, (Object)"\u0421\u0423"));
        passportTypeMap.put(PassportType.CERTIFICATEOFRELEASE, (MiscUtil.Pair<Integer, String>)MiscUtil.Pair.of((Object)10, (Object)"\u0421\u041e"));
        passportTypeMap.put(PassportType.RESIDENCEPERMIT, (MiscUtil.Pair<Integer, String>)MiscUtil.Pair.of((Object)11, (Object)"\u0412\u0416"));
    }
}

