/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.kz;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.KzRailGdsAccount;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.system.HttpRequest;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.IBusRailKzContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.KzHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.KzRequestParameters;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.http.IBusHttpContextKeys;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class KzHttpRequestBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        KzRequestParameters reqParams = (KzRequestParameters)ctx.getMandatoryObject((Enum)IBusRailKzContextKeys.KZ_REQUEST_PARAMS);
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        String fsTicketCookie = (String)ctx.getObject((Enum)IBusRailKzContextKeys.KZ_FS_TICKET_COOKIE);
        String ktjTicketCookie = (String)ctx.getObject((Enum)IBusRailKzContextKeys.KZ_KTJ_TICKET_COOKIE);
        KzRailGdsAccount gdsAccount = (KzRailGdsAccount)accountCtr.getEntity();
        KzHelper.checkAddress(gdsAccount.getMainAddress());
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(KzHelper.buildUrl(reqParams, gdsAccount));
        if (reqParams.getRequest() != null) {
            httpRequest.setBody(this.buildContent(reqParams.getRequest()));
        } else if (reqParams.getContent() != null) {
            httpRequest.setBody(reqParams.getContent());
        }
        httpRequest.setRequestMethod(reqParams.getOperation().getRequestMethod());
        httpRequest.getRequestProperties().put((Object)"Cookie", (Object)this.buildCookies(fsTicketCookie, ktjTicketCookie));
        httpRequest.getRequestProperties().put((Object)"Connection", (Object)"close");
        if (httpRequest.getBody() == null) {
            httpRequest.getRequestProperties().put((Object)"Content-Length", (Object)"0");
        } else {
            httpRequest.getRequestProperties().put((Object)"Content-Type", (Object)"application/json");
        }
        ctx.putObject((Enum)IBusHttpContextKeys.HTTP_REQUEST, (Object)httpRequest);
    }

    private String buildCookies(String fsTicketCookie, String ktjTicketCookie) {
        return Stream.of(fsTicketCookie, ktjTicketCookie).filter(Objects::nonNull).collect(Collectors.joining(";"));
    }

    private byte[] buildContent(Object request) throws Exception {
        String content = KzHelper.MAPPER.writeValueAsString(request);
        return content.getBytes(StandardCharsets.UTF_8);
    }
}

