/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.kz;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.gridnine.xtrip.common.ibecorp.exception.GdsOrderIsBookedException;
import com.gridnine.xtrip.common.ibecorp.exception.GdsOrderIsCancelledException;
import com.gridnine.xtrip.common.ibecorp.exception.GdsOrderNotFoundException;
import com.gridnine.xtrip.common.ibecorp.exception.NoTrainsException;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.system.HttpResponse;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.IBusRailKzContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.KzAbstractHttpResponseParser;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.KzHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.KzOperation;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.KzRequestParameters;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.exception.WorkSessionNotStartedException;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.model.BaseKzResponse;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.model.GetOrderStatusRS;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.http.IBusHttpContextKeys;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KzHttpResponseParser
extends KzAbstractHttpResponseParser {
    private static final Map<Integer, String> CODE_MESSAGES_MAP = new HashMap<Integer, String>();

    public void process(MessageContext ctx) throws Exception {
        KzRequestParameters reqParams = (KzRequestParameters)ctx.getMandatoryObject((Enum)IBusRailKzContextKeys.KZ_REQUEST_PARAMS);
        HttpResponse httpResponse = (HttpResponse)ctx.getMandatoryObject((Enum)IBusHttpContextKeys.HTTP_RESPONSE);
        this.checkResponse(httpResponse, true);
        KzOperation operation = reqParams.getOperation();
        Object baseResponse = this.parseHttpResponse(httpResponse, operation.getResponseClass(), operation.isAsList());
        if (baseResponse instanceof BaseKzResponse) {
            this.checkErrors((BaseKzResponse)baseResponse);
        }
        if (httpResponse.getError() != null) {
            throw Xeption.forDeveloper((String)"error: {0}", (Object[])new Object[]{new String(httpResponse.getError())});
        }
        ctx.putObject((Enum)IBusRailKzContextKeys.KZ_RESPONSE, baseResponse);
    }

    private Object parseHttpResponse(HttpResponse httpResponse, Class responseClass, boolean asList) throws Exception {
        if (httpResponse.getError() != null) {
            String error = new String(httpResponse.getError());
            if (error.startsWith("[") && error.endsWith("]")) {
                error = error.substring(1, error.length() - 1);
            }
            try {
                return KzHelper.MAPPER.readValue(error, (Class)MiscUtil.guarded((Object)responseClass, BaseKzResponse.class));
            }
            catch (Exception ex) {
                throw Xeption.forDeveloper((String)"error: {0}", (Object[])new Object[]{error});
            }
        }
        if (responseClass == null) {
            return null;
        }
        String body = new String(httpResponse.getBody());
        if (asList) {
            CollectionType listType = KzHelper.MAPPER.getTypeFactory().constructCollectionType(List.class, responseClass);
            return KzHelper.MAPPER.readValue(body, (JavaType)listType);
        }
        return KzHelper.MAPPER.readValue(body, responseClass);
    }

    private void checkErrors(BaseKzResponse baseResponse) {
        String translated;
        if (baseResponse == null) {
            return;
        }
        if (baseResponse.getServerStatus() == null && TextUtil.isBlank((String)baseResponse.getErrorMessage())) {
            return;
        }
        if (MiscUtil.equals((Object)1060005, (Object)baseResponse.getServerStatus())) {
            throw new WorkSessionNotStartedException();
        }
        if (MiscUtil.equals((Object)1092014, (Object)baseResponse.getServerStatus())) {
            throw new NoTrainsException();
        }
        if (baseResponse instanceof GetOrderStatusRS) {
            if (MiscUtil.equals((Object)0x111700, (Object)baseResponse.getServerStatus())) {
                throw new GdsOrderNotFoundException();
            }
            if (MiscUtil.equals((Object)1120004, (Object)baseResponse.getServerStatus())) {
                if (MiscUtil.equals((Object)"1", (Object)baseResponse.getAttemptedValue())) {
                    throw new GdsOrderIsBookedException();
                }
                if (MiscUtil.equals((Object)"4", (Object)baseResponse.getAttemptedValue())) {
                    throw new GdsOrderIsCancelledException();
                }
            }
        }
        if (TextUtil.nonBlank((String)(translated = CODE_MESSAGES_MAP.get(baseResponse.getServerStatus())))) {
            throw Xeption.forEndUser((String)L10nResourcesManager.getStr((String)translated, (Object[])new Object[0]), (Object[])new Object[0]);
        }
        throw Xeption.forEndUser((String)baseResponse.getErrorMessage(), (Object[])new Object[0]);
    }

    static {
        CODE_MESSAGES_MAP.put(1092021, "RAILWAY_MESSAGE_ON_A_GIVEN_DIRECTION_OR_TRAIN_NO_SEATSEMENTS");
    }
}

