/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.kz;

import com.gridnine.xtrip.common.ibecorp.model.KzRailGdsAccount;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.railway.RailwayCarrier;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.gds.test.GDSTestBase;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.KzHelper;
import com.gridnine.xtrip.server.model.test.XModelAssert;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;

public class KzTestBase
extends GDSTestBase {
    protected void configureMetaregistry(MetaRegistry metaRegistry) throws Exception {
        super.configureMetaregistry(metaRegistry);
        this.registerModel(metaRegistry, "com/gridnine/xtrip/common/railway/model/model-basic-railway.xml");
        this.registerModel(metaRegistry, "com/gridnine/xtrip/common/railway/model/model-railway.xml");
        this.registerModel(metaRegistry, "com/gridnine/xtrip/common/ibecorp/model-railway-ibecorp.xml");
    }

    public void setUp() throws Exception {
        super.setUp();
        this.initDicts();
    }

    protected void initDicts() {
        Arrays.asList("\u0424\u041f\u041a", "\u0414\u041e\u0421\u0421").forEach(code -> {
            RailwayCarrier dict = new RailwayCarrier();
            dict.setCode(code);
            DictionaryCache.get().put((BaseDictionary)dict);
        });
    }

    protected EntityContainer<KzRailGdsAccount> buildKzRailGdsAccount() {
        KzRailGdsAccount account = new KzRailGdsAccount();
        account.setGds(GdsName.RAIL_KZ);
        EntityContainer ctr = EntityContainer.create((BaseEntity)account);
        return ctr;
    }

    protected void writeResult(List<? extends XSerializable> objects, String fileName) throws Exception {
        String path = ((Object)((Object)this)).getClass().getResource("").getPath().replace("/classes/", "/source-test/");
        path = URLDecoder.decode(path, "utf-8");
        File file = new File(path + fileName);
        try (FileOutputStream fos = new FileOutputStream(file);){
            XUtil.serialize(objects, (OutputStream)fos);
        }
    }

    protected void writeResult(XSerializable object, String fileName) throws Exception {
        String path = ((Object)((Object)this)).getClass().getResource("").getPath().replace("/classes/", "/source-test/");
        path = URLDecoder.decode(path, "utf-8");
        File file = new File(path + fileName);
        try (FileOutputStream fos = new FileOutputStream(file);){
            XUtil.serialize((XSerializable)object, (OutputStream)fos);
        }
    }

    protected Object getJsonObjectFromFile(String fileName, Class responseClass) throws IOException {
        String body = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(fileName));
        return KzHelper.MAPPER.readValue(body, responseClass);
    }

    protected <T extends BaseEntity> void assertList(List<T> expectedList, List<T> actualList, Consumer<T> doBeforeAssert) {
        Assert.assertEquals((long)expectedList.size(), (long)actualList.size());
        for (int i = 0; i < actualList.size(); ++i) {
            BaseEntity expected = (BaseEntity)expectedList.get(i);
            BaseEntity actual = (BaseEntity)actualList.get(i);
            if (doBeforeAssert != null) {
                doBeforeAssert.accept(expected);
                doBeforeAssert.accept(actual);
            }
            XModelAssert.assertEntityEquals((String)String.format("item[%d]", i), (BaseEntity)expected, (BaseEntity)actual);
        }
    }

    protected void assertReservation(Reservation expected, Reservation actual) {
        this.clearFields(expected);
        this.clearFields(actual);
        XModelAssert.assertEntityEquals((BaseEntity)expected, (BaseEntity)actual);
    }

    private void clearFields(Reservation res) {
        res.getProducts().stream().map(RailwayProduct.class::cast).forEach(prod -> prod.setIssueDate(null));
    }
}

