/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.auth;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.bof.midoffice.ibus.MaskSensitiveTraceDataHelper;
import com.gridnine.xtrip.common.ibecorp.model.KzRailGdsAccount;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.system.HttpRequest;
import com.gridnine.xtrip.common.model.system.RequestMethod;
import com.gridnine.xtrip.common.util.Base64;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.KzHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.KzOperation;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.KzRequestParameters;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.http.IBusHttpContextKeys;

public class KzGetTokenRequestBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        KzRailGdsAccount gdsAccount = (KzRailGdsAccount)accountCtr.getEntity();
        KzHelper.checkAddress(gdsAccount.getGetTokenAddress());
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(KzHelper.buildUrl(new KzRequestParameters(KzOperation.GetToken), gdsAccount));
        httpRequest.setRequestMethod(RequestMethod.GET);
        httpRequest.getRequestProperties().put((Object)"Connection", (Object)"close");
        String authData = KzGetTokenRequestBuilder.buildAuthorizationHeader(gdsAccount);
        httpRequest.getRequestProperties().put((Object)"Authorization", (Object)authData);
        MaskSensitiveTraceDataHelper.addMaskedValue((MessageContext)ctx, (String)authData);
        ctx.putObject((Enum)IBusHttpContextKeys.HTTP_REQUEST, (Object)httpRequest);
    }

    private static String buildAuthorizationHeader(KzRailGdsAccount account) {
        return "Basic ".concat(Base64.encode((byte[])String.format("%s:%s", account.getAccount(), account.getPassword()).getBytes()));
    }
}

