/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.createReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.KzRailGdsAccount;
import com.gridnine.xtrip.common.ibecorp.model.PlacingRequirements;
import com.gridnine.xtrip.common.ibecorp.model.RzdReservationCreationParameters;
import com.gridnine.xtrip.common.ibecorp.model.RzdTraveller;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdBookingSegmentParams;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdCar;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdPrice;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTrain;
import com.gridnine.xtrip.common.midoffice.helper.CodeTranslator;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.railway.ServiceClass;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.RzdHelper;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.RailwayHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.IBusRailKzContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.KzHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.KzOperation;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.KzRequestParameters;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.model.BuyRQ;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.model.common.TariffType;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.railway.model.helpers.RzdServiceConverter;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class KzBuyRequestBuilder
extends BaseProcessor {
    private static final CodeTranslator COUNTRY_TRANSLATOR = new CodeTranslator(new String[]{CodeSystem.ISO_ALPHA3.name()});

    public void process(MessageContext ctx) {
        RzdReservationCreationParameters params = (RzdReservationCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        RzdBookingSegmentParams segmentParams = (RzdBookingSegmentParams)ctx.getMandatoryObject((Enum)IBusRailwayContextKeys.RAILWAY_BOOKING_SEGMENT_PARAMS);
        List travellers = (List)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLERS);
        PaymentType payment = (PaymentType)ctx.getObject((Enum)IBusGdsContextKeys.PAYMENT_TYPE);
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        ctx.putObject((Enum)IBusRailKzContextKeys.KZ_REQUEST_PARAMS, (Object)new KzRequestParameters(KzOperation.Buy).setRequest(this.buildRequest(params, segmentParams, travellers, payment, (KzRailGdsAccount)accountCtr.getEntity())));
    }

    private BuyRQ buildRequest(RzdReservationCreationParameters params, RzdBookingSegmentParams segmentParams, List<Traveller> travellers, PaymentType payment, KzRailGdsAccount gdsAccount) {
        BuyRQ result = new BuyRQ();
        RzdTrain train = segmentParams.getTrain();
        result.setStationFrom(KzHelper.getNativeCode(train.getPassengerFrom()));
        result.setStationTo(KzHelper.getNativeCode(train.getPassengerTo()));
        LocalDateTime depDate = Objects.requireNonNull(DateUtils.toLocalDateTime((Date)train.getDepartureDatetime()));
        result.setDepDate(depDate);
        result.setDepTime(depDate.toLocalTime());
        result.setTrain(this.buildTrain(train));
        result.setCar(this.buildCar(segmentParams.getRzdPrice(), segmentParams.getRzdCar()));
        result.setRequirements(this.buildRequirements(segmentParams.getPlacing()));
        for (RzdTraveller rzdTraveller : params.getRzdTravellers()) {
            Traveller traveller = (Traveller)CollectionUtil.find(travellers, (String)rzdTraveller.getTravellerUid());
            if (traveller == null) continue;
            boolean isAdult = DictHelper.isAdultPassengerTypeCategory((DictionaryReference)rzdTraveller.getPassengerType());
            boolean isInfant = DictHelper.isInfantPassengerType((DictionaryReference)rzdTraveller.getPassengerType());
            String bonusCardNumber = traveller.getRailwayBonusCard() == null ? null : traveller.getRailwayBonusCard().getNumber();
            BuyRQ.Blank gdsBlank = new BuyRQ.Blank();
            gdsBlank.setSeatsCount(1);
            gdsBlank.setTariffType(TextUtil.nonBlank((String)bonusCardNumber) ? TariffType.DISCOUNT : (isAdult ? TariffType.FULL : TariffType.KID));
            gdsBlank.getPassengers().add(this.buildPassenger(traveller, isInfant));
            result.getBlanks().add(gdsBlank);
        }
        result.setCreditCard(payment != PaymentType.CASH);
        result.setMachineKey(gdsAccount.getMachineKey());
        return result;
    }

    private BuyRQ.Requirements buildRequirements(PlacingRequirements plReq) {
        BuyRQ.Requirements result = new BuyRQ.Requirements();
        result.setSeatsComp(KzHelper.convertKupeIndicationToGds(plReq.getKupeIndication()));
        result.setCompType(KzHelper.convertCompartmentTypeToGds(plReq.getGender()));
        result.setSeatsBottom(plReq.getLowerSeatsCount());
        result.setSeatsTop(plReq.getUpperSeatsCount());
        BuyRQ.SeatsRange seatsRange = new BuyRQ.SeatsRange();
        seatsRange.setStart(plReq.getSeatRangeFirst());
        seatsRange.setEnd(plReq.getSeatRangeLast());
        result.setSeatsRange(seatsRange);
        if (plReq.getWithBedding() != null) {
            result.setWoBedding(plReq.getWithBedding() == false);
        }
        return result;
    }

    private BuyRQ.TrainData buildTrain(RzdTrain train) {
        BuyRQ.TrainData result = new BuyRQ.TrainData();
        result.setNumber(train.getNumber());
        return result;
    }

    private BuyRQ.CarData buildCar(RzdPrice rzdPrice, RzdCar rzdCar) {
        BuyRQ.CarData result = new BuyRQ.CarData();
        result.setType(KzHelper.convertCarriageTypeToGds(rzdPrice.getCategory()));
        result.setNumber(rzdCar.getNumber());
        result.setClassService(RzdServiceConverter.getServiceClassName((ServiceClass)rzdPrice.getServiceClass()));
        return result;
    }

    private BuyRQ.Passenger buildPassenger(Traveller traveller, boolean isInfant) {
        String email;
        BuyRQ.Passenger result = new BuyRQ.Passenger();
        Passport passport = traveller.getPassport();
        if (traveller.getRailwayBonusCard() != null && TextUtil.nonBlank((String)traveller.getRailwayBonusCard().getNumber())) {
            result.setCardNumber(traveller.getRailwayBonusCard().getNumber());
        }
        result.setDocType(KzHelper.convertPassportTypeToGdsInt(passport.getType(), (DictionaryReference<Country>)passport.getCitizenship()));
        result.setDoc(passport.getNumber());
        BuyRQ.Name name = new BuyRQ.Name();
        name.setLastName(RzdHelper.modifyNameForGds(passport.getLastName()));
        name.setFirstName(RzdHelper.modifyNameForGds(RailwayHelper.getFullFirstName(passport)));
        name.setPatronymic(RzdHelper.modifyNameForGds(passport.getMiddleName(), true));
        result.setName(name);
        result.setChildBirthday(DateUtils.toLocalDateTime((Date)passport.getBirthday()));
        result.setWithoutPlace(isInfant);
        result.setCitizenship(COUNTRY_TRANSLATOR.getNativeCode(passport.getCitizenship()));
        result.setSex(KzHelper.convertGenderToGds(passport.getGender()));
        Communication phone = KzHelper.getPhoneCommunication(traveller);
        if (phone != null) {
            BuyRQ.PassengerPhone ph = new BuyRQ.PassengerPhone();
            ph.setPhoneNumber(CommonHelper.buildPhoneNumber(phone));
            result.setPassengerPhone(ph);
        }
        if (TextUtil.nonBlank((String)(email = ProfileHelper.getCommunicationEmail((List)traveller.getCommunications())))) {
            BuyRQ.PassengerEmail pe = new BuyRQ.PassengerEmail();
            pe.setEmailAddress(email);
            result.setPassengerEmail(pe);
        }
        result.setPassengerIin(traveller.getIIN());
        return result;
    }
}

