/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.createReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.KzRailGdsAccount;
import com.gridnine.xtrip.common.ibecorp.model.RzdReservationCreationParameters;
import com.gridnine.xtrip.common.ibecorp.model.RzdTraveller;
import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.VatComponent;
import com.gridnine.xtrip.common.model.booking.VatDetalization;
import com.gridnine.xtrip.common.model.booking.railway.CarriageType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.booking.railway.ReservedSeat;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.Principal;
import com.gridnine.xtrip.common.model.dict.railway.RailwayRoute;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.LanguageUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.RzdHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.RailwayHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.IBusRailKzContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.KzHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.model.BuyRS;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.model.common.Passenger;
import com.gridnine.xtrip.server.ibus.IbusHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.railway.model.helpers.RzdServiceConverter;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class KzBuyResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) {
        BuyRS response = (BuyRS)ctx.getMandatoryObject((Enum)IBusRailKzContextKeys.KZ_RESPONSE);
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        List travellers = (List)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLERS);
        RzdReservationCreationParameters params = (RzdReservationCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        List reservations = (List)IbusHelper.getObjectN((MessageContext)ctx, (Enum)IBusMidofficeContextKeys.RESERVATIONS, ArrayList::new);
        Reservation reservation = this.createReservation(response, travellers, (EntityContainer<KzRailGdsAccount>)accountCtr, params);
        ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 {0} \u0441\u043e\u0437\u0434\u0430\u043d\u043e", (Object[])new Object[]{CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation)}));
        reservations.add(reservation);
        ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATION, (Object)reservation);
    }

    private Reservation createReservation(BuyRS response, List<Traveller> travellers, EntityContainer<KzRailGdsAccount> accountCtr, RzdReservationCreationParameters params) {
        KzRailGdsAccount gdsAccount = (KzRailGdsAccount)accountCtr.getEntity();
        Reservation reservation = new Reservation();
        CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)reservation, (GdsName)gdsAccount.getGds(), (RecordLocatorType)RecordLocatorType.DEFAULT, (String)String.valueOf(response.getOrder().getId()));
        if (TextUtil.nonBlank((String)response.getOrder().getExpressID())) {
            CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)reservation, (GdsName)GdsName.EXPRESS, (RecordLocatorType)RecordLocatorType.DEFAULT, (String)String.valueOf(response.getOrder().getExpressID()));
        }
        reservation.setResDate(KzHelper.convertZonedDateFromGds(response.getOrder().getCreateDate(), gdsAccount));
        ArrayList<Traveller> lostTravellers = new ArrayList<Traveller>(travellers);
        for (BuyRS.Ticket gdsTicket : response.getTickets()) {
            RailwayProduct product = this.createProduct(gdsTicket, response, lostTravellers, params.getRzdTravellers(), gdsAccount);
            BookingHelper.addProduct((Reservation)reservation, (BaseProduct)product);
        }
        this.correctLostInfants(reservation, lostTravellers, params.getRzdTravellers());
        if (!lostTravellers.isEmpty()) {
            throw Xeption.forDeveloper((String)("Lost travellers: " + lostTravellers.stream().map(Traveller::getName).collect(Collectors.joining(", "))), (Object[])new Object[0]);
        }
        return reservation;
    }

    private RailwayProduct createProduct(BuyRS.Ticket gdsTicket, BuyRS response, List<Traveller> travellers, List<RzdTraveller> rzdTravellers, KzRailGdsAccount gdsAccount) {
        List<Traveller> productTravellers = this.findTravellers(gdsTicket.getPassengers(), travellers);
        RailwayProduct product = new RailwayProduct();
        product.setTicketType(TicketType.OWN);
        product.setEticket(true);
        product.setIssueDate(new Date());
        product.setStatus(ProductStatus.BOOKING);
        product.getPassengers().addAll(productTravellers);
        for (Traveller traveller : productTravellers) {
            RzdTraveller rzdTraveller = RailwayHelper.getRzdTraveller(traveller.getUid(), rzdTravellers);
            RailwayProductHelper.setPassengerType((RailwayProduct)product, (Traveller)traveller, (DictionaryReference)rzdTraveller.getPassengerType());
        }
        product.setBlankId(KzHelper.buildBlankId(gdsTicket));
        product.setExpressId(gdsTicket.getExpressID());
        String gdsCurrency = gdsAccount.getCurrency() == null ? null : gdsAccount.getCurrency().getCode();
        product.setGdsCurrency(gdsCurrency);
        BigDecimal totalFare = gdsTicket.getTariff();
        BigDecimal totalFareVat = gdsTicket.getTariffNDS();
        BigDecimal serviceFare = gdsTicket.getTariffService();
        BigDecimal serviceFareVat = gdsTicket.getTariffServiceNDS();
        BigDecimal fare = MiscUtil.sub((BigDecimal)totalFare, (BigDecimal[])new BigDecimal[]{serviceFare});
        product.setEquivalentFare(fare);
        BigDecimal fareVat = MiscUtil.sub((BigDecimal)totalFareVat, (BigDecimal[])new BigDecimal[]{serviceFareVat});
        product.setEquivalentVAT(fareVat);
        product.setServiceFare(serviceFare);
        product.setServiceVAT(serviceFareVat);
        product.setTotalEquivalentFare(totalFare);
        product.setTotalEquivalentVAT(totalFareVat);
        if (fareVat != null || serviceFareVat != null) {
            VatDetalization vendorVatDetalization = new VatDetalization();
            vendorVatDetalization.setDetalized(true);
            if (fareVat != null) {
                vendorVatDetalization.getComponents().add(this.buildVatComponent(fare, fareVat, VatBasisType.FARE));
            }
            if (serviceFareVat != null) {
                vendorVatDetalization.getComponents().add(this.buildVatComponent(serviceFare, serviceFareVat, VatBasisType.SERVICE));
            }
            product.setVendorVatDetalization(vendorVatDetalization);
        }
        CarriageType carriageType = KzHelper.convertCarriageTypeFromGds(response.getCar().getType());
        product.setWithBedding(Boolean.valueOf(!gdsTicket.isNoBedding()));
        String serialNumber = response.getCarrier().getInn();
        if (TextUtil.nonBlank((String)serialNumber)) {
            DictionaryReference<Principal> principalRef;
            serialNumber = serialNumber.replaceAll("\\D", "");
            String bin = response.getCar().getCarrierName();
            if (TextUtil.nonBlank((String)bin)) {
                bin = bin.replaceAll("\\D", "");
            }
            if ((principalRef = RzdHelper.getPrincipalForKz(bin, serialNumber)) == null) {
                principalRef = RzdHelper.createPrincipalForKz(response.getCarrier().getName(), bin, serialNumber);
            }
            product.setCarrier(principalRef);
        }
        RailwaySegment segment = new RailwaySegment();
        segment.setNumber(1);
        segment.setDepartureStation(KzHelper.resolveNativeCode(RailwayStation.class, response.getDeparture().getStationCode()));
        segment.setArriveStation(KzHelper.resolveNativeCode(RailwayStation.class, response.getArrival().getStationCode()));
        segment.setDepartureDate(DateUtils.toJavaDate((LocalDateTime)response.getDeparture().getDate()));
        segment.setArriveDate(DateUtils.toJavaDate((LocalDateTime)response.getArrival().getDate()));
        if (Integer.valueOf(100).equals(response.getDeparture().getTimezone())) {
            segment.setLocalDepartureDate(segment.getDepartureDate());
        }
        if (Integer.valueOf(100).equals(response.getArrival().getTimezone())) {
            segment.setLocalArriveDate(segment.getArriveDate());
        }
        segment.setTrainArriveToStationDate(segment.getArriveDate());
        segment.setTrainArriveToStationLocalDate(segment.getLocalArriveDate());
        RzdHelper.writeFullTrainNumber(segment, response.getDeparture().getTrain());
        segment.setDepartureTrainNumber(response.getDeparture().getTrain());
        segment.setArrivalTrainNumber(response.getArrival().getTrain());
        segment.setCarriageNumber(response.getCar().getNumber());
        segment.getPlaces().addAll(gdsTicket.getSeats());
        segment.setCarriageType(carriageType);
        segment.setServiceClass(RzdServiceConverter.getServiceClassByName((String)response.getCar().getClassService()));
        segment.setEquivalentFare(gdsTicket.getTariffB());
        segment.setFare(MoneyHelper.buildMoney((BigDecimal)gdsTicket.getTariffB(), (String)gdsCurrency));
        segment.setRoute(KzHelper.resolveNativeCode(RailwayRoute.class, response.getCar().getOwnerType()));
        segment.setTimeInfo(response.getDepartureAndArrivalTimeInfo());
        segment.setInternational(Boolean.valueOf(response.getOrder().isInternational()));
        product.getSegments().add(segment);
        ReservedSeat reservedSeat = new ReservedSeat();
        reservedSeat.setSegment(segment);
        reservedSeat.setFare(MoneyHelper.buildMoney((BigDecimal)gdsTicket.getTariffPWithoutService(), (String)gdsCurrency));
        reservedSeat.setEquivalentFare(gdsTicket.getTariffPWithoutService());
        product.getReservedSeats().add(reservedSeat);
        return product;
    }

    private List<Traveller> findTravellers(List<Passenger> passengers, List<Traveller> travellers) {
        ArrayList<Traveller> result = new ArrayList<Traveller>();
        for (Passenger passenger : passengers) {
            Traveller traveller = travellers.stream().filter(tr -> this.isSameTraveller((Traveller)tr, passenger)).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"can't find traveller {0} {1}", (Object[])new Object[]{passenger.getDoc(), passenger.getName()}));
            travellers.remove(traveller);
            result.add(traveller);
        }
        return result;
    }

    private boolean isSameTraveller(Traveller tr, Passenger gdsPassenger) {
        Passport psp = tr.getPassport();
        String doc = KzHelper.convertPassportTypeToGdsStr(psp.getType(), (DictionaryReference<Country>)psp.getCitizenship()) + psp.getNumber();
        if (!MiscUtil.equals((Object)this.normalizeName(doc), (Object)this.normalizeName(gdsPassenger.getDoc()))) {
            if (TextUtil.isBlank((String)tr.getIIN())) {
                return false;
            }
            String docIIN = "\u0418\u0418" + tr.getIIN();
            if (!MiscUtil.equals((Object)docIIN, (Object)gdsPassenger.getDoc())) {
                return false;
            }
        }
        String name = String.join((CharSequence)"=", psp.getLastName(), RailwayHelper.getFullFirstName(psp), TextUtil.isBlank((String)psp.getMiddleName()) ? "-" : psp.getMiddleName());
        return MiscUtil.equals((Object)this.normalizeName(name), (Object)this.normalizeName(gdsPassenger.getName()));
    }

    private String normalizeName(String name) {
        if (name == null) {
            return null;
        }
        return KzBuyResponseParser.replace(LanguageUtil.translitToEnglish((String)name));
    }

    public static String replace(String name) {
        return name.replaceAll("\u0401", "E").replaceAll("\u042a", "\u042c");
    }

    private VatComponent buildVatComponent(BigDecimal fare, BigDecimal fareVat, VatBasisType vatBasisType) {
        VatComponent vatComponent = new VatComponent();
        vatComponent.setBasis(fare);
        vatComponent.setSum(fareVat);
        vatComponent.setRate(this.calcVatRate(fare, fareVat));
        vatComponent.getBasisTypes().add(vatBasisType);
        return vatComponent;
    }

    private Double calcVatRate(BigDecimal total, BigDecimal vatAmount) {
        VatAmount va = VatAmount.of((BigDecimal)total, (BigDecimal)vatAmount);
        Double vatRate = va.getVat();
        if (vatRate != null) {
            vatRate = Math.round(vatRate);
        }
        return vatRate;
    }

    private void correctLostInfants(Reservation reservation, List<Traveller> lostTravellers, List<RzdTraveller> rzdTravellers) {
        Iterator<Traveller> iterator = lostTravellers.iterator();
        while (iterator.hasNext()) {
            Traveller traveller = iterator.next();
            RzdTraveller rzdTraveller = RailwayHelper.getRzdTraveller(traveller.getUid(), rzdTravellers);
            if (!DictHelper.isInfantPassengerType((DictionaryReference)rzdTraveller.getPassengerType())) continue;
            RailwayProduct product = RzdCommonHelper.getProducts((Reservation)reservation).stream().filter(rp -> {
                List passengerTypes = RailwayProductHelper.getPassengerTypes((RailwayProduct)rp);
                return passengerTypes.size() == 1 && DictHelper.isAdultPassengerTypeCategory((DictionaryReference)((DictionaryReference)passengerTypes.get(0)));
            }).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"no adult for infant", (Object[])new Object[0]));
            product.getPassengers().add(traveller);
            RailwayProductHelper.setPassengerType((RailwayProduct)product, (Traveller)traveller, (DictionaryReference)rzdTraveller.getPassengerType());
            iterator.remove();
        }
    }
}

