/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.createReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.RzdReservationCreationParameters;
import com.gridnine.xtrip.common.ibecorp.model.RzdTraveller;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.IBusRailKzContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.KzTestBase;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.createReservation.KzBuyResponseParser;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.model.BuyRS;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.junit.Test;

public class KzBuyResponseParserTest
extends KzTestBase {
    private final KzBuyResponseParser processor = new KzBuyResponseParser();

    @Test
    public void test1Adt() throws Throwable {
        String scenario = "1Adt";
        this.testScenario(scenario, false);
    }

    @Test
    public void test1Adt1Inf() throws Throwable {
        String scenario = "1Adt1Inf";
        this.testScenario(scenario, true);
    }

    private void testScenario(String scenario, boolean withInfant) throws Exception {
        String responseFile = scenario + ".json";
        String resultFile = scenario + "_result.xml";
        Object response = this.getJsonObjectFromFile(responseFile, BuyRS.class);
        MessageContext ctx = new MessageContext();
        ctx.putObject((Enum)IBusRailKzContextKeys.KZ_RESPONSE, response);
        ctx.putObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT, this.buildKzRailGdsAccount());
        ctx.putObject((Enum)IBusMidofficeContextKeys.TRAVELLERS, this.buildTravellers(withInfant));
        ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS, (Object)this.buildCreationParameters(withInfant));
        this.processor.process(ctx);
        Reservation actReservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        Reservation expReservation = (Reservation)this.loadXSerializable(resultFile, Reservation.class);
        this.assertReservation(expReservation, actReservation);
    }

    private RzdReservationCreationParameters buildCreationParameters(boolean withInfant) {
        RzdReservationCreationParameters result = new RzdReservationCreationParameters();
        RzdTraveller gdsTr = new RzdTraveller();
        gdsTr.setPassengerType(DictHelper.getAdultPassengerType());
        gdsTr.setTravellerUid("travellerAdult1");
        result.getRzdTravellers().add(gdsTr);
        if (withInfant) {
            gdsTr = new RzdTraveller();
            gdsTr.setPassengerType(DictHelper.getInfantPassengerType());
            gdsTr.setTravellerUid("travellerInfant");
            result.getRzdTravellers().add(gdsTr);
        }
        return result;
    }

    private List<Traveller> buildTravellers(boolean withInfant) throws Exception {
        ArrayList<Traveller> result = new ArrayList<Traveller>();
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
        Traveller tr = new Traveller();
        tr.setUid("travellerAdult1");
        tr.setName("Traveller adult 1");
        Passport psp = new Passport();
        psp.setLastName("PETROV");
        psp.setFirstName("PETR");
        psp.setMiddleName("\u0420\u0415\u0422R\u041eVI\u0421\u041d");
        psp.setBirthday(sdf.parse("11.11.1982"));
        psp.setType(PassportType.FOREIGN);
        psp.setNumber("123456788");
        tr.setPassport(psp);
        result.add(tr);
        if (withInfant) {
            tr = new Traveller();
            tr.setUid("travellerInfant");
            tr.setName("Traveller infant");
            psp = new Passport();
            psp.setLastName("PETROV");
            psp.setFirstName("INFANT");
            psp.setBirthday(sdf.parse("11.11.2019"));
            tr.setPassport(psp);
            psp.setType(PassportType.FOREIGN);
            psp.setNumber("123456768");
            result.add(tr);
        }
        return result;
    }
}

