/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.createReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.RzdReservationCreationParameters;
import com.gridnine.xtrip.common.ibecorp.model.RzdTraveller;
import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdValidationMessages;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonValidationHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.KzHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class KzReservationCreationParametersValidator
extends BaseProcessor {
    private final List<String> AVAILABLE_PHONE_CITY_CODES = Arrays.asList("700", "701", "702", "705", "706", "707", "708", "730", "747", "771", "775", "776", "777", "778");

    public void process(MessageContext ctx) {
        RzdReservationCreationParameters params = (RzdReservationCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        List travellers = (List)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLERS);
        this.validateParamsAndTravellers(travellers, params);
    }

    private void validateParamsAndTravellers(List<Traveller> travellers, RzdReservationCreationParameters params) {
        if (!params.getRzdTravellers().isEmpty()) {
            this.validateRzdTravellers(travellers, params);
        }
    }

    private void validateRzdTravellers(List<Traveller> travellers, RzdReservationCreationParameters params) {
        for (RzdTraveller rzdTraveller : params.getRzdTravellers()) {
            Traveller traveller = (Traveller)CollectionUtil.find(travellers, (String)rzdTraveller.getTravellerUid());
            if (traveller == null) continue;
            this.validateTraveller(traveller);
        }
    }

    private void validateTraveller(Traveller traveller) {
        Communication phone = KzHelper.getPhoneCommunication(traveller);
        if (phone != null && (TextUtil.isBlank((String)phone.getCountryCode()) || !this.AVAILABLE_PHONE_CITY_CODES.contains(phone.getCityCode()))) {
            Collection messages = CollectionUtil.getOrAddList((Map)traveller.getValidationContext().getCommunicationsListValidationMessages(), (Object)traveller.getCommunications().indexOf(phone));
            messages.add(RzdValidationMessages.getNotAvailablePhoneCountryCode((String)this.AVAILABLE_PHONE_CITY_CODES.toString()));
        }
        CommonValidationHelper.validatePersonIin(traveller.getIIN(), RzdCommonHelper.isKzCitizenship((Passport)traveller.getPassport()), traveller.getValidationContext().getIINValidationMessages());
    }
}

