/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.getTrainRoute;

import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdRoute;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdRoutePoint;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.IBusRailKzContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.KzHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.model.GetTrainRoutesRS;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;

public class KzGetTrainRoutesResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        GetTrainRoutesRS response = (GetTrainRoutesRS)ctx.getMandatoryObject((Enum)IBusRailKzContextKeys.KZ_RESPONSE);
        ctx.putObject((Enum)IBusRailwayContextKeys.RAILWAY_TRAIN_ROUTES, this.buildRoutes(response));
    }

    private List<RzdRoute> buildRoutes(GetTrainRoutesRS response) {
        ArrayList<RzdRoute> result = new ArrayList<RzdRoute>();
        for (GetTrainRoutesRS.Route route : response.getRoutes()) {
            RzdRoute rzdRoute = new RzdRoute();
            rzdRoute.setTitle(route.getTitle());
            rzdRoute.setDeparture(route.getRoute().get(0));
            rzdRoute.setArrival(route.getRoute().get(1));
            for (GetTrainRoutesRS.Stop stop : route.getStops()) {
                RzdRoutePoint point = new RzdRoutePoint();
                point.setStationName(stop.getStation());
                point.setStationCode(stop.getCode());
                point.setArrivalTime(stop.getArvTime());
                if (stop.getWaitingTime() != null) {
                    point.setStopTime(Duration.ofMinutes(KzHelper.calcMinutes(stop.getWaitingTime()).intValue()));
                }
                point.setDepartureTime(stop.getDepTime());
                point.setTimeDescription(stop.getSign());
                rzdRoute.getPoints().add(point);
            }
            result.add(rzdRoute);
        }
        return result;
    }
}

