/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.getTrainSeats;

import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdGetTrainSeatsParameters;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.IBusRailKzContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.KzHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.KzOperation;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.KzRequestParameters;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.model.SearchCarsRQ;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.time.LocalDateTime;
import java.util.Date;

public class KzSearchCarsRequestBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        RzdGetTrainSeatsParameters params = (RzdGetTrainSeatsParameters)ctx.getMandatoryObject((Enum)IBusRailwayContextKeys.RAILWAY_GET_TRAIN_SEATS_PARAMETERS);
        ctx.putObject((Enum)IBusRailKzContextKeys.KZ_REQUEST_PARAMS, (Object)new KzRequestParameters(KzOperation.SearchCars).setRequest(this.buildRequest(params)));
    }

    private SearchCarsRQ buildRequest(RzdGetTrainSeatsParameters params) {
        SearchCarsRQ result = new SearchCarsRQ();
        result.setDetailNumPlaces(true);
        result.setDetailTypePlaces(false);
        result.setStationFrom(KzHelper.getNativeCode(params.getDeparture()));
        result.setStationTo(KzHelper.getNativeCode(params.getArrival()));
        SearchCarsRQ.DirectionInfo dir = new SearchCarsRQ.DirectionInfo();
        LocalDateTime localDt = DateUtils.toLocalDateTime((Date)params.getDepartureDate());
        SearchCarsRQ.DateWrapper date = new SearchCarsRQ.DateWrapper();
        date.setValue(localDt.toLocalDate().atStartOfDay());
        dir.setDepDate(date);
        dir.setDepTime(localDt.toLocalTime());
        SearchCarsRQ.TrainNumber train = new SearchCarsRQ.TrainNumber();
        train.setNumber(params.getTrainNumber());
        dir.setTrain(train);
        result.setForwardDirection(dir);
        return result;
    }
}

