/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.getTrainSeats;

import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdCar;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdGetTrainSeatsParameters;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdGetTrainSeatsResult;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdPrice;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdPriceValues;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTariff;
import com.gridnine.xtrip.common.model.booking.railway.CarriageType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.RzdHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.IBusRailKzContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.KzHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.model.SearchCarsRS;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.model.common.Seats;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Arrays;

public class KzSearchCarsResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        RzdGetTrainSeatsParameters params = (RzdGetTrainSeatsParameters)ctx.getMandatoryObject((Enum)IBusRailwayContextKeys.RAILWAY_GET_TRAIN_SEATS_PARAMETERS);
        SearchCarsRS response = (SearchCarsRS)ctx.getMandatoryObject((Enum)IBusRailKzContextKeys.KZ_RESPONSE);
        ctx.putObject((Enum)IBusRailwayContextKeys.RAILWAY_GET_TRAIN_SEATS_RESULT, (Object)this.buildResult(response, params));
    }

    private RzdGetTrainSeatsResult buildResult(SearchCarsRS response, RzdGetTrainSeatsParameters params) {
        RzdGetTrainSeatsResult result = new RzdGetTrainSeatsResult();
        SearchCarsRS.TrainsData trainsData = response.getForwardDirection().getTrainsData().get(0);
        SearchCarsRS.Train train = trainsData.getTrain();
        for (SearchCarsRS.CarInfo carInfo : train.getCars()) {
            RzdPrice price = this.buildPrice(carInfo, train, trainsData.getDate(), params);
            if (price == null) continue;
            result.getPrices().add(price);
        }
        return result;
    }

    private RzdPrice buildPrice(SearchCarsRS.CarInfo carInfo, SearchCarsRS.Train train, LocalDateTime departureDate, RzdGetTrainSeatsParameters params) {
        boolean isFemaleCar;
        CarriageType carriageType = KzHelper.convertCarriageTypeFromGds(carInfo.getType());
        if (params.getCarriageType() != null && !MiscUtil.equals((Object)carriageType, (Object)params.getCarriageType())) {
            return null;
        }
        RzdPrice price = new RzdPrice();
        price.setCategory(carriageType);
        price.setCategoryTitle(carInfo.getType());
        if (RzdCommonHelper.isKzStation((DictionaryReference)params.getDeparture()) && RzdCommonHelper.isKzStation((DictionaryReference)params.getArrival())) {
            price.getAvailableTariffs().addAll(Arrays.asList(RzdTariff.FULL, RzdTariff.CHILD_KTZ, RzdTariff.INFANT_KTZ));
        } else {
            price.getAvailableTariffs().addAll(Arrays.asList(RzdTariff.FULL, RzdTariff.CHILD, RzdTariff.BABY));
        }
        price.getAvailableDocuments().addAll(KzHelper.getAvailablePassportTypes());
        price.setPrice(this.buildPriceValues(carInfo));
        price.setServiceClass(KzHelper.getServiceClass(carInfo.getClassService()));
        price.setServiceClassCode(carInfo.getClassService().getType());
        price.setSubcategory(carInfo.getAddSigns());
        boolean bl = isFemaleCar = price.getSubcategory() != null && price.getSubcategory().contains("\u0416\u041d");
        if (isFemaleCar) {
            price.setSubcategory(price.getSubcategory().replaceFirst("\u0416\u041d", "\u041c\u0416"));
        }
        price.setRoute(carInfo.getOwner().getType());
        price.setCarrier(RzdHelper.getCarrier(carInfo.getCarrier().getName()));
        price.setWithDiscount(false);
        price.setTrainName(train.getBrand());
        String trainNumber = train.getNumber();
        price.setTrainNumber(trainNumber);
        LocalDateTime date = (LocalDateTime)MiscUtil.guarded((Object)train.getDeparture().getDate(), (Object)departureDate);
        price.setDepartureDatetime(DateUtils.toJavaDate((LocalDateTime)LocalDateTime.of(date.toLocalDate(), train.getDeparture().getTime())));
        boolean isBeddingEnabled = carriageType == CarriageType.P && KzHelper.calcMinutes(train.getTimeInWay()) <= 360;
        carInfo.getCars().stream().map(car -> this.convertCarFromGds((SearchCarsRS.Car)car, train.getArrival(), trainNumber, isBeddingEnabled, isFemaleCar)).forEach(price.getCars()::add);
        return price;
    }

    private RzdPriceValues buildPriceValues(SearchCarsRS.CarInfo carInfo) {
        BigDecimal serv = carInfo.getTariffService();
        BigDecimal minTariff = MiscUtil.guarded((BigDecimal)carInfo.getTariff());
        BigDecimal maxTariff = MiscUtil.guarded((BigDecimal)carInfo.getTariff2());
        if (MiscUtil.isZero((BigDecimal)maxTariff, (boolean)true)) {
            maxTariff = minTariff;
        }
        return this.createPriceValues(minTariff, maxTariff, serv);
    }

    private RzdPriceValues createPriceValues(BigDecimal minTariff, BigDecimal maxTariff, BigDecimal serv) {
        RzdPriceValues pv = new RzdPriceValues();
        pv.setOriginal(maxTariff);
        pv.setOriginalMin(minTariff);
        pv.setServiceCost(serv);
        return pv;
    }

    private RzdCar convertCarFromGds(SearchCarsRS.Car gdsCar, SearchCarsRS.DateTimeInfo gdsArrival, String trainNumber, boolean isBeddingEnabled, boolean isFemaleCar) {
        RzdCar result = new RzdCar();
        result.setTrainNumber(trainNumber);
        result.setNumber(gdsCar.getNumber());
        result.setERegEnabled(gdsCar.getElRegPossible() != null && (gdsCar.getElRegPossible().isAkp() || gdsCar.getElRegPossible().isUk()));
        result.setCarSubType(gdsCar.getSubType());
        result.setBeddingEnabled(isBeddingEnabled);
        result.setArrivalDatetime(DateUtils.toJavaDate((LocalDateTime)LocalDateTime.of(gdsArrival.getDate().toLocalDate(), gdsArrival.getTime())));
        result.setLocalArrivalDatetime(DateUtils.toJavaDate((LocalDateTime)LocalDateTime.of(gdsArrival.getLocalDate().toLocalDate(), gdsArrival.getLocalTime())));
        if (isFemaleCar) {
            gdsCar.getPlaces().stream().map(str -> str.concat("\u0416")).forEach(result.getVacantSeats()::add);
        } else {
            result.getVacantSeats().addAll(gdsCar.getPlaces());
        }
        Seats seats = gdsCar.getSeats();
        result.setTotalPlaceCount(MiscUtil.guarded((Integer)seats.getSeatsUp()) + MiscUtil.guarded((Integer)seats.getSeatsLateralUp()) + MiscUtil.guarded((Integer)seats.getSeatsDn()) + MiscUtil.guarded((Integer)seats.getSeatsLateralDn()) + MiscUtil.guarded((Integer)seats.getSeatsUndef()));
        return result;
    }
}

