/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.model.BaseKzResponse;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.model.common.IntCodeEnum;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.model.common.Passenger;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.model.common.TariffType;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

public class GetOrderStatusRS
extends BaseKzResponse {
    @JsonProperty(value="OrderInfo")
    private OrderInfo orderInfo;
    @JsonProperty(value="TicketsStatuses")
    private List<TicketStatus> ticketsStatuses;

    public OrderInfo getOrderInfo() {
        return this.orderInfo;
    }

    public List<TicketStatus> getTicketsStatuses() {
        return this.ticketsStatuses;
    }

    public static enum TicketState {
        PaymentConfirmed,
        PaymentConfirmedElReg,
        PaymentUnconfirmed,
        Cancelled,
        Returned,
        ClaimReturned,
        BoardingPass,
        DeferredPayment;

    }

    public static class TicketStatus {
        @JsonProperty(value="TicketId")
        private String ticketId;
        @JsonProperty(value="ExpressID")
        private String expressID;
        @JsonProperty(value="State")
        private TicketState state;
        @JsonProperty(value="Seats")
        private String seats;
        @JsonProperty(value="Passengers")
        private List<Passenger> passengers;
        @JsonProperty(value="TariffType")
        private TariffType tariffType;
        @JsonProperty(value="Tariff")
        private BigDecimal tariff;

        public String getTicketId() {
            return this.ticketId;
        }

        public String getExpressID() {
            return this.expressID;
        }

        public TicketState getState() {
            return this.state;
        }

        public String getSeats() {
            return this.seats;
        }

        public List<Passenger> getPassengers() {
            return this.passengers;
        }

        public TariffType getTariffType() {
            return this.tariffType;
        }

        public BigDecimal getTariff() {
            return this.tariff;
        }
    }

    public static enum OrderStatus implements IntCodeEnum
    {
        Done(0),
        OrderNotFound(1),
        OrderCanceled(2),
        OrderNotConfirmed(4),
        OrderInProcess(10),
        OrderBlocked(11);

        Integer code;

        private OrderStatus(int code) {
            this.code = code;
        }

        @Override
        public Integer getCode() {
            return this.code;
        }
    }

    public static class OrderInfo {
        @JsonProperty(value="OrderId")
        private Integer orderId;
        @JsonProperty(value="Status")
        private Integer status;
        @JsonProperty(value="TerminalName")
        private String terminalName;
        @JsonProperty(value="DepartureTrainNumber")
        private String departureTrainNumber;
        @JsonProperty(value="DepartureStation")
        private String departureStation;
        @JsonProperty(value="DepartureDateTime")
        private LocalDateTime departureDateTime;
        @JsonProperty(value="ArrivalTrainNumber")
        private String arrivalTrainNumber;
        @JsonProperty(value="ArrivalStation")
        private String arrivalStation;
        @JsonProperty(value="ArrivalDateTime")
        private LocalDateTime arrivalDateTime;
        @JsonProperty(value="CarNumber")
        private String carNumber;
        @JsonProperty(value="CarType")
        private Integer carType;
        @JsonProperty(value="CarClassService")
        private String carClassService;
        @JsonProperty(value="CarAddSigns")
        private String carAddSigns;
        @JsonProperty(value="CarrierName")
        private String carrierName;
        @JsonProperty(value="ExpressId")
        private String expressId;
        @JsonProperty(value="OrderCreateDate")
        private LocalDateTime orderCreateDate;

        public Integer getOrderId() {
            return this.orderId;
        }

        public OrderStatus getStatus() {
            return IntCodeEnum.fromValue(OrderStatus.class, this.status);
        }

        public String getTerminalName() {
            return this.terminalName;
        }

        public String getDepartureTrainNumber() {
            return this.departureTrainNumber;
        }

        public String getDepartureStation() {
            return this.departureStation;
        }

        public LocalDateTime getDepartureDateTime() {
            return this.departureDateTime;
        }

        public String getArrivalTrainNumber() {
            return this.arrivalTrainNumber;
        }

        public String getArrivalStation() {
            return this.arrivalStation;
        }

        public LocalDateTime getArrivalDateTime() {
            return this.arrivalDateTime;
        }

        public String getCarNumber() {
            return this.carNumber;
        }

        public Integer getCarType() {
            return this.carType;
        }

        public String getCarClassService() {
            return this.carClassService;
        }

        public String getCarAddSigns() {
            return this.carAddSigns;
        }

        public String getCarrierName() {
            return this.carrierName;
        }

        public String getExpressId() {
            return this.expressId;
        }

        public LocalDateTime getOrderCreateDate() {
            return this.orderCreateDate;
        }
    }
}

