/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.refund;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.KzRailGdsAccount;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.IBusRailKzContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.KzHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.KzOperation;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.KzRequestParameters;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.model.ApplyReturnRQ;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.model.GetReturnRequestStatusRS;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;

public class KzApplyReturnRequestBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        RailwayProduct product = (RailwayProduct)ctx.getMandatoryObject((Enum)IBusRailwayContextKeys.RAILWAY_PRODUCT);
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        GetReturnRequestStatusRS requestStatusResponse = (GetReturnRequestStatusRS)ctx.getMandatoryObject((Enum)IBusRailKzContextKeys.KZ_GET_RETURN_REQUEST_STATUS_RESPONSE);
        BigDecimal refAmount = requestStatusResponse.getReturnResult().getRetTariff();
        ctx.putObject((Enum)IBusRailKzContextKeys.KZ_REQUEST_PARAMS, (Object)new KzRequestParameters(KzOperation.ApplyReturn).setRequest(this.buildRequest(product, (KzRailGdsAccount)accountCtr.getEntity(), refAmount)));
    }

    private ApplyReturnRQ buildRequest(RailwayProduct product, KzRailGdsAccount gdsAccount, BigDecimal refAmount) throws Exception {
        ApplyReturnRQ result = new ApplyReturnRQ();
        ApplyReturnRQ.ReturnRequest rr = new ApplyReturnRQ.ReturnRequest();
        rr.setReturnOperationTransactionId(Integer.valueOf(product.getRefundTransId()));
        result.setReturnRequest(rr);
        ApplyReturnRQ.Refund ref = new ApplyReturnRQ.Refund();
        ref.setTerminal(gdsAccount.getTerminal());
        ref.setAmount(refAmount);
        ref.setRequisite(product.getExpressId());
        String content = KzHelper.MAPPER.writeValueAsString((Object)ref);
        ref.setSignature(KzHelper.calcSignature(content, gdsAccount));
        result.getRefunds().add(ref);
        return result;
    }
}

