/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.refund;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.KzRailGdsAccount;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.RailwayHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.IBusRailKzContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.KzHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.model.GetReturnRequestStatusRS;
import com.gridnine.xtrip.server.ibecorp.rzd.model.RefundTransactionInfo;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Date;

public class KzApplyReturnResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        RailwayProduct product = (RailwayProduct)ctx.getMandatoryObject((Enum)IBusRailwayContextKeys.RAILWAY_PRODUCT);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        GetReturnRequestStatusRS requestStatusResponse = (GetReturnRequestStatusRS)ctx.getMandatoryObject((Enum)IBusRailKzContextKeys.KZ_GET_RETURN_REQUEST_STATUS_RESPONSE);
        EntityReference agentRef = salesContext == null ? null : salesContext.getAgent();
        this.refundProduct(reservation, product, requestStatusResponse, (EntityReference<Person>)agentRef, (KzRailGdsAccount)accountCtr.getEntity());
        ctx.putObject((Enum)IBusRailwayContextKeys.RAILWAY_REFUND_WAS_CHANGED, (Object)Boolean.TRUE);
        ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0411\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 {0}: \u0431\u0438\u043b\u0435\u0442 {1} \u0432\u043e\u0437\u0432\u0440\u0430\u0449\u0435\u043d", (Object[])new Object[]{CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation), product.getSystemNumber()}));
    }

    private void refundProduct(Reservation reservation, RailwayProduct product, GetReturnRequestStatusRS requestStatusResponse, EntityReference<Person> agentRef, KzRailGdsAccount gdsAccount) throws Exception {
        RefundTransactionInfo.BlankPrice refBlankPrice = new RefundTransactionInfo.BlankPrice();
        refBlankPrice.setPrice(requestStatusResponse.getReturnResult().getRetTariff());
        Date refundDate = KzHelper.convertZonedDateFromGds(requestStatusResponse.getReturnResult().getOperationDateTime(), gdsAccount);
        RailwayProduct refundProduct = RailwayHelper.refundRailwayProduct(reservation, product, agentRef, refBlankPrice, refundDate);
        GetReturnRequestStatusRS.ReturnRequestTicket gdsTicket = requestStatusResponse.getReturnResult().getTickets().stream().filter(ticket -> MiscUtil.equals((Object)ticket.getExpressID(), (Object)product.getSystemNumber())).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"can't find ticket with systemNumber (ExpressID) {0}", (Object[])new Object[]{product.getSystemNumber()}));
        refundProduct.setKrsNumber(gdsTicket.getKrs());
    }
}

