/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.refund;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.IBusRailKzContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.exception.FailedReturnException;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.model.GetReturnRequestStatusRS;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Arrays;
import java.util.List;

public class KzCheckReturnRequestStatus
extends BaseProcessor {
    private static List<GetReturnRequestStatusRS.ReturnRequestStatus> SUCCEEDED_STATUSES = Arrays.asList(GetReturnRequestStatusRS.ReturnRequestStatus.Succeeded, GetReturnRequestStatusRS.ReturnRequestStatus.Applied);

    public void process(MessageContext ctx) throws Exception {
        RailwayProduct product = (RailwayProduct)ctx.getMandatoryObject((Enum)IBusRailwayContextKeys.RAILWAY_PRODUCT);
        GetReturnRequestStatusRS response = (GetReturnRequestStatusRS)ctx.getMandatoryObject((Enum)IBusRailKzContextKeys.KZ_GET_RETURN_REQUEST_STATUS_RESPONSE);
        this.checkStatus(response, product);
    }

    private void checkStatus(GetReturnRequestStatusRS response, RailwayProduct product) {
        if (SUCCEEDED_STATUSES.contains(response.getStatus())) {
            product.setStatus(ProductStatus.SELL);
            return;
        }
        if (response.getStatus() == GetReturnRequestStatusRS.ReturnRequestStatus.Queued) {
            product.setStatus(ProductStatus.REQUEST);
            return;
        }
        if (response.getStatus() == GetReturnRequestStatusRS.ReturnRequestStatus.Processing) {
            product.setStatus(ProductStatus.REQUEST);
            return;
        }
        if (response.getStatus() == GetReturnRequestStatusRS.ReturnRequestStatus.Rejected) {
            throw new FailedReturnException("\u0417\u0430\u043f\u0440\u043e\u0441 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430 \u043e\u0442\u0432\u0435\u0440\u0433\u043d\u0443\u0442");
        }
        if (response.getStatus() == GetReturnRequestStatusRS.ReturnRequestStatus.Error) {
            throw new FailedReturnException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430");
        }
        throw Xeption.forDeveloper((String)"unknown ReturnRequestStatus", (Object[])new Object[0]);
    }
}

