/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.searchTrains;

import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdSearchTrainsParameters;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTrain;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTrainWithCategories;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.IBusRailKzContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.KzHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.KzOperation;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.KzRequestParameters;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.model.SearchTrainsRQ;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import java.util.List;

public class KzSearchTrainsRequestBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        RzdSearchTrainsParameters params = (RzdSearchTrainsParameters)ctx.getMandatoryObject((Enum)IBusRailwayContextKeys.RAILWAY_SEARCH_TRAINS_PARAMETERS);
        List trains = (List)ctx.getObject((Enum)IBusRailwayContextKeys.RAILWAY_SEARCH_TRAINS_LIST);
        ctx.putObject((Enum)IBusRailKzContextKeys.KZ_REQUEST_PARAMS, (Object)new KzRequestParameters(KzOperation.SearchTrains).setRequest(this.buildRequest(params, trains)));
    }

    private SearchTrainsRQ buildRequest(RzdSearchTrainsParameters params, List<RzdTrainWithCategories> trains) {
        SearchTrainsRQ result = new SearchTrainsRQ();
        result.setStationFrom(KzHelper.getNativeCode(params.getDeparture()));
        result.setStationTo(KzHelper.getNativeCode(params.getArrival()));
        Date lastTrainDate = this.findLastTrainDate(trains);
        result.setForwardDateInfo(this.buildDateInfo(params.getDepartureDate(), params.getTimeFrom(), params.getTimeTo(), lastTrainDate));
        return result;
    }

    private Date findLastTrainDate(List<RzdTrainWithCategories> trains) {
        if (CollectionUtil.isEmpty(trains)) {
            return null;
        }
        return trains.stream().map(RzdTrainWithCategories::getTrain).map(RzdTrain::getDepartureDatetime).max(Date::compareTo).orElse(null);
    }

    private SearchTrainsRQ.DateInfo buildDateInfo(Date date, Integer timeFrom, Integer timeTo, Date lastTrainDate) {
        if (date == null) {
            return null;
        }
        SearchTrainsRQ.DateInfo result = new SearchTrainsRQ.DateInfo();
        LocalDate localDate = DateUtils.toLocalDate((Date)date);
        if (lastTrainDate == null) {
            int hoursFrom = (Integer)MiscUtil.guarded((Object)timeFrom, (Object)0);
            result.setDateTimeFrom(LocalDateTime.of(localDate, LocalTime.of(hoursFrom, 0)));
        } else {
            result.setDateTimeFrom(DateUtils.toLocalDateTime((Date)lastTrainDate).plusMinutes(1L));
        }
        int hoursTo = (Integer)MiscUtil.guarded((Object)timeTo, (Object)24) - 1;
        result.setDateTimeTo(LocalDateTime.of(localDate, LocalTime.of(hoursTo, 59)));
        return result;
    }
}

