/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.searchTrains;

import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdCategory;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdSearchTrainsParameters;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTrain;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTrainWithCategories;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.railway.CarriageType;
import com.gridnine.xtrip.common.model.booking.railway.ServiceClass;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.RzdHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.RailwayHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.IBusRailKzContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.KzHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.model.SearchTrainsRS;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.model.common.Seats;
import com.gridnine.xtrip.server.ibus.IbusHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.BooleanUtils;

public class KzSearchTrainsResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        RzdSearchTrainsParameters searchParams = (RzdSearchTrainsParameters)ctx.getMandatoryObject((Enum)IBusRailwayContextKeys.RAILWAY_SEARCH_TRAINS_PARAMETERS);
        SearchTrainsRS response = (SearchTrainsRS)ctx.getMandatoryObject((Enum)IBusRailKzContextKeys.KZ_RESPONSE);
        List trains = (List)IbusHelper.getObjectN((MessageContext)ctx, (Enum)IBusRailwayContextKeys.RAILWAY_SEARCH_TRAINS_LIST, ArrayList::new);
        trains.addAll(this.buildTrains(response, searchParams));
    }

    private List<RzdTrainWithCategories> buildTrains(SearchTrainsRS response, RzdSearchTrainsParameters searchParams) {
        ArrayList<RzdTrainWithCategories> result = new ArrayList<RzdTrainWithCategories>();
        SearchTrainsRS.DirectionTrains directionTrains = response.getForwardDirection();
        if (CollectionUtil.isEmpty(directionTrains.getTrainsData())) {
            return result;
        }
        if (directionTrains.getTrainsData().size() != 1) {
            throw Xeption.forDeveloper((String)"unsupported size of TrainsData", (Object[])new Object[0]);
        }
        boolean isBusinessClass = BooleanUtils.isTrue((Boolean)searchParams.getBusinessClass());
        SearchTrainsRS.TrainsData trainsData = directionTrains.getTrainsData().get(0);
        for (SearchTrainsRS.Train train : trainsData.getTrains()) {
            RzdTrain rzdTrain = this.buildTrain(train);
            rzdTrain.setPassengerFrom(KzHelper.resolveNativeCode(RailwayStation.class, directionTrains.getPassRouteCodeFrom()));
            rzdTrain.setPassengerTo(KzHelper.resolveNativeCode(RailwayStation.class, directionTrains.getPassRouteCodeTo()));
            boolean isGroupByServiceClass = this.isGroupByServiceClass(train);
            RzdTrainWithCategories trainWithCategory = new RzdTrainWithCategories();
            trainWithCategory.setTrain(rzdTrain);
            rzdTrain.setGroupedByServiceClass(isGroupByServiceClass);
            HashMap<String, RzdCategory> carsMap = new HashMap<String, RzdCategory>();
            for (SearchTrainsRS.Car car : train.getCars()) {
                for (SearchTrainsRS.Tariff tariff : car.getTariffs()) {
                    String classService = tariff.getClassService().getType();
                    if (isBusinessClass && !classService.startsWith("1")) continue;
                    String key = isGroupByServiceClass ? classService : String.valueOf(car.getType());
                    RzdCategory category = (RzdCategory)carsMap.get(key);
                    if (category == null) {
                        category = this.buildCategory(car, tariff);
                        if (category == null) continue;
                        category.setTrainNumber(train.getNumber());
                        trainWithCategory.getCategories().add(category);
                        carsMap.put(key, category);
                        continue;
                    }
                    this.addCarInfo(category, tariff);
                }
            }
            if (trainWithCategory.getCategories().isEmpty()) continue;
            result.add(trainWithCategory);
        }
        return result;
    }

    private RzdTrain buildTrain(SearchTrainsRS.Train train) {
        RzdTrain rzdTrain = new RzdTrain();
        rzdTrain.setNumber(train.getNumber());
        rzdTrain.setDisplayNumber(train.getNumber2());
        rzdTrain.setCategory(train.getType());
        rzdTrain.setBrand(train.getBrand());
        rzdTrain.setDeparture(train.getRoute().get(0));
        rzdTrain.setArrival(train.getRoute().get(1));
        rzdTrain.setDepartureDatetime(DateUtils.toJavaDate((LocalDateTime)train.getDepartureDateTime()));
        rzdTrain.setArrivalDatetime(DateUtils.toJavaDate((LocalDateTime)train.getArrivalDateTime()));
        rzdTrain.setLocalDepartureDatetime(DateUtils.toJavaDate((LocalDateTime)train.getDepartureLocalDateTime()));
        rzdTrain.setLocalArrivalDatetime(DateUtils.toJavaDate((LocalDateTime)train.getArrivalLocalDateTime()));
        rzdTrain.setWayTime(KzHelper.calcMinutes(train.getTimeInWay()));
        rzdTrain.setERegEnabled(train.isElRegPossible());
        return rzdTrain;
    }

    private boolean isGroupByServiceClass(SearchTrainsRS.Train train) {
        if (!RzdCommonHelper.isSapsan((String)train.getBrand())) {
            return false;
        }
        Set carTypes = train.getCars().stream().map(SearchTrainsRS.Car::getType).filter(Objects::nonNull).collect(Collectors.toSet());
        return carTypes.size() == 1;
    }

    private RzdCategory buildCategory(SearchTrainsRS.Car car, SearchTrainsRS.Tariff tariff) {
        CarriageType carriageType = KzHelper.convertCarriageTypeFromGds(car.getType());
        if (carriageType == null) {
            return null;
        }
        RzdCategory category = new RzdCategory();
        category.setCarriageType(carriageType);
        category.setPriceOriginalMin(MiscUtil.minimum((BigDecimal[])new BigDecimal[]{tariff.getTariffValue(), tariff.getTariffValue2()}));
        category.setSeatsCount(this.calcSeatsCount(tariff.getSeats()));
        category.setCarrier(RzdHelper.getCarrier(tariff.getCarrier().getName()));
        category.setSubcategory(tariff.getAddSigns());
        this.addServiceClass(category, tariff);
        return category;
    }

    private void addCarInfo(RzdCategory category, SearchTrainsRS.Tariff tariff) {
        category.setPriceOriginalMin(MiscUtil.minimum((BigDecimal[])new BigDecimal[]{category.getPriceOriginalMin(), tariff.getTariffValue(), tariff.getTariffValue2()}));
        category.setSeatsCount(Integer.valueOf(category.getSeatsCount() + this.calcSeatsCount(tariff.getSeats())));
        this.addServiceClass(category, tariff);
        category.setSubcategory(RailwayHelper.mergeSubCategories(category.getSubcategory(), tariff.getAddSigns()));
    }

    private void addServiceClass(RzdCategory category, SearchTrainsRS.Tariff tariff) {
        ServiceClass serviceClass = KzHelper.getServiceClass(tariff.getClassService());
        if (serviceClass == null) {
            return;
        }
        if (!category.getServiceClasses().contains(serviceClass)) {
            category.getServiceClasses().add(serviceClass);
        }
    }

    private Integer calcSeatsCount(Seats seats) {
        return Stream.of(seats.getSeatsUndef(), seats.getSeatsDn(), seats.getSeatsUp(), seats.getSeatsLateralDn(), seats.getSeatsLateralUp()).filter(Objects::nonNull).reduce(0, (nmb1, nmb2) -> nmb1 + nmb2);
    }
}

