/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.simulateRefund;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.IBusRailKzContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.model.GetOrderStatusRS;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class KzGetOrderStatusCheckProcessor
extends BaseProcessor {
    private static List<GetOrderStatusRS.TicketState> AVAILABLE_STATES = Arrays.asList(GetOrderStatusRS.TicketState.PaymentConfirmedElReg, GetOrderStatusRS.TicketState.PaymentConfirmed);

    public void process(MessageContext ctx) throws Exception {
        List products = (List)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BASE_PRODUCTS);
        GetOrderStatusRS response = (GetOrderStatusRS)ctx.getMandatoryObject((Enum)IBusRailKzContextKeys.KZ_GET_ORDER_STATUS_RESPONSE);
        this.checkStatuses(response, products);
    }

    private void checkStatuses(GetOrderStatusRS response, List<BaseProduct> products) {
        if (response.getOrderInfo().getStatus() != GetOrderStatusRS.OrderStatus.Done) {
            throw Xeption.forDeveloper((String)"OrderStatus != Done", (Object[])new Object[0]);
        }
        Set expressIdsToRefund = products.stream().filter(RailwayProduct.class::isInstance).map(RailwayProduct.class::cast).map(RailwayProduct::getExpressId).collect(Collectors.toSet());
        boolean invalidStateExists = response.getTicketsStatuses().stream().filter(ts -> expressIdsToRefund.contains(ts.getExpressID())).anyMatch(ts -> !AVAILABLE_STATES.contains((Object)ts.getState()));
        if (invalidStateExists) {
            throw Xeption.forDeveloper((String)"exists ticket with invalid status", (Object[])new Object[0]);
        }
    }
}

