/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.simulateRefund;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.KzRailGdsAccount;
import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.RailwayHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.IBusRailKzContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.KzHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.model.GetTicketReturnInfoRS;
import com.gridnine.xtrip.server.ibecorp.rzd.model.RefundTransactionInfo;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Date;

public class KzGetTicketReturnInfoResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        String blankId = (String)ctx.getMandatoryObject((Enum)IBusRailwayContextKeys.RAILWAY_OBJECT_VALUE);
        GetTicketReturnInfoRS response = (GetTicketReturnInfoRS)ctx.getMandatoryObject((Enum)IBusRailKzContextKeys.KZ_RESPONSE);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        EntityReference agentRef = salesContext == null ? null : salesContext.getAgent();
        this.refundProduct(reservation, blankId, response, (EntityReference<Person>)agentRef, (KzRailGdsAccount)accountCtr.getEntity());
    }

    private void refundProduct(Reservation reservation, String blankId, GetTicketReturnInfoRS response, EntityReference<Person> agentRef, KzRailGdsAccount gdsAccount) throws Exception {
        RailwayProduct rp = RzdCommonHelper.getSellProductByBlankId((Reservation)reservation, (String)blankId);
        if (rp == null) {
            throw Xeption.forDeveloper((String)"can't find rail product with blankId {0}", (Object[])new Object[]{blankId});
        }
        GetTicketReturnInfoRS.TicketReturnInfo gdsTicket = response.getTickets().stream().filter(t -> MiscUtil.equals((Object)t.getExpressID(), (Object)rp.getExpressId())).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"can't find reservation system ticket with ExpressID {0}", (Object[])new Object[]{rp.getExpressId()}));
        Date refundDate = KzHelper.convertZonedDateFromGds(response.getOperationTimeStamp(), gdsAccount);
        RefundTransactionInfo.BlankPrice refBlankPrice = new RefundTransactionInfo.BlankPrice();
        refBlankPrice.setPrice(gdsTicket.getRetTariff());
        RailwayProduct refProduct = RailwayHelper.refundRailwayProduct(reservation, rp, agentRef, refBlankPrice, refundDate);
    }
}

