/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.syncReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.helpers.BookingStreamHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.IBusRailKzContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.KzHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.model.GetOrderStatusRS;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public class CollectProductsForRefundProcessor
extends BaseProcessor {
    private static final Set<ProductStatus> REFUNDABLE_PRODUCT_STATUSES = EnumSet.of(ProductStatus.SELL, ProductStatus.REQUEST);

    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        GetOrderStatusRS response = (GetOrderStatusRS)ctx.getMandatoryObject((Enum)IBusRailKzContextKeys.KZ_GET_ORDER_STATUS_RESPONSE);
        ctx.putObject((Enum)IBusMidofficeContextKeys.BASE_PRODUCTS, this.collectProducts(reservation, response));
    }

    private List<BaseProduct> collectProducts(Reservation reservation, GetOrderStatusRS response) {
        ArrayList<BaseProduct> result = new ArrayList<BaseProduct>();
        for (GetOrderStatusRS.TicketStatus gdsTicketsStatus : response.getTicketsStatuses()) {
            RailwayProduct product;
            ProductStatus gdsStatus = KzHelper.convertToProductStatus(gdsTicketsStatus.getState());
            if (gdsStatus != ProductStatus.REFUND || (product = BookingStreamHelper.getProductsStream((Reservation)reservation, RailwayProduct.class).filter(rp -> MiscUtil.equals((Object)rp.getSystemNumber(), (Object)gdsTicketsStatus.getExpressID())).filter(rp -> REFUNDABLE_PRODUCT_STATUSES.contains(rp.getStatus())).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"can't find railway product for refund in reservation {0} with number {1}", (Object[])new Object[]{CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation), gdsTicketsStatus.getExpressID()}))).getNextProduct() != null) continue;
            result.add((BaseProduct)product);
        }
        return result;
    }
}

