/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.syncReservation;

import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.time.FastDateFormat;

public abstract class KzBaseUpdater {
    protected boolean changed = false;
    protected List<Message> messages;
    private static FastDateFormat DF = FastDateFormat.getInstance((String)"dd.MM.yyyy HH:mm");

    abstract String getCaption();

    protected <O, T> boolean update(String caption, O oldObj, O newObj, Function<O, T> getter, BiConsumer<O, O> setter) {
        return this.update(caption, oldObj, newObj, getter, setter, Objects::nonNull);
    }

    protected <O, T> boolean update(String caption, O oldObj, O newObj, Function<O, T> getter, BiConsumer<O, O> setter, Function<T, Boolean> valueValidator) {
        T newValue;
        T oldValue = getter.apply(oldObj);
        if (!KzBaseUpdater.equals(oldValue, newValue = getter.apply(newObj))) {
            if (!valueValidator.apply(newValue).booleanValue()) {
                return false;
            }
            setter.accept(oldObj, newObj);
            this.addUpdateMessage(caption, oldValue, newValue);
            this.changed = true;
            return true;
        }
        return false;
    }

    private <T> void addInsertMessage(String caption) {
        StringBuilder sb = this.createProductCaptionsStringBuilder(caption);
        sb.append(": ").append("\u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u043e");
        this.messages.add(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)sb.toString(), (Object[])new Object[0]));
    }

    private <T> void addUpdateMessage(String caption, T oldValue, T newValue) {
        StringBuilder sb = this.createProductCaptionsStringBuilder(caption);
        sb.append(": ").append(KzBaseUpdater.toString(oldValue)).append("->").append(KzBaseUpdater.toString(newValue));
        this.messages.add(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)sb.toString(), (Object[])new Object[0]));
    }

    private <T> void addDeleteMessage(String caption) {
        StringBuilder sb = this.createProductCaptionsStringBuilder(caption);
        sb.append(": ").append("\u0443\u0434\u0430\u043b\u0435\u043d\u043e");
        this.messages.add(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)sb.toString(), (Object[])new Object[0]));
    }

    static String toString(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof Date) {
            return KzBaseUpdater.dateToString((Date)value);
        }
        return value.toString();
    }

    static String dateToString(Date date) {
        return DF.format(date);
    }

    private static <T> boolean equals(T o1, T o2, Function<T, ?> getter) {
        return KzBaseUpdater.equals(getter.apply(o1), getter.apply(o2));
    }

    private static <T> boolean equalsOrValue2isNull(T o1, T o2, Function<T, ?> getter) {
        Object val2 = getter.apply(o2);
        return val2 == null || KzBaseUpdater.equals(getter.apply(o1), val2);
    }

    public static <T> boolean equals(T o1, T o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1 instanceof Money) {
            Money m1 = (Money)o1;
            Money m2 = (Money)o2;
            return MiscUtil.equals((Object)m1.getValue(), (Object)m2.getValue()) && MiscUtil.equals((Object)m1.getCurrency(), (Object)m2.getCurrency());
        }
        return MiscUtil.equals(o1, o2);
    }

    private StringBuilder createProductCaptionsStringBuilder(String caption) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getCaption());
        if (TextUtil.nonBlank((String)caption)) {
            sb.append("/").append(caption);
        }
        return sb;
    }

    private String concatCaption(String caption, String add) {
        return Stream.of(caption, add).filter(TextUtil::nonBlank).collect(Collectors.joining("/"));
    }
}

