/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.syncReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.IBusRailKzContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import org.apache.commons.lang.BooleanUtils;

public class KzCollectMessagesProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        Boolean changed = (Boolean)ctx.getObject((Enum)IBusRailKzContextKeys.KZ_RESERVATION_CHANGED);
        Message message = this.buildMessage(ctx.getMessagesReadOnly(), reservation, BooleanUtils.isTrue((Boolean)changed));
        ctx.clearMessages();
        ctx.addMessage(message);
    }

    private Message buildMessage(Collection<Message> messages, Reservation reservation, boolean changed) {
        MessageType mesType = MessageType.MESSAGE;
        for (Message mes : messages) {
            if (mes.getType() == MessageType.ERROR) {
                mesType = MessageType.ERROR;
                break;
            }
            if (mes.getType() != MessageType.WARNING) continue;
            mesType = MessageType.WARNING;
        }
        String recordLocator = CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation);
        Message result = new Message();
        result.setType(mesType);
        if (changed) {
            result.setMessage(L10nResourcesManager.createL10nMessage((String)"\u0411\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 {0} \u0431\u044b\u043b\u043e \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u043e", (Object[])new Object[]{recordLocator}));
        } else {
            result.setMessage(L10nResourcesManager.createL10nMessage((String)"\u0411\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 {0} \u043e\u0441\u0442\u0430\u043b\u043e\u0441\u044c \u0431\u0435\u0437 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439", (Object[])new Object[]{recordLocator}));
        }
        result.setDetails(MessageHelper.toSimpleString(messages));
        return result;
    }
}

