/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.syncReservation;

import com.gridnine.bof.midoffice.ibus.BookingFileOperationParameters;
import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.KzRailGdsAccount;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.SearchQueryHelper;
import com.gridnine.xtrip.common.model.ibecorp.ImportKzBookingParameters;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.IBusRailKzContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class KzFindOrCreateBookingProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        ImportKzBookingParameters parameters = (ImportKzBookingParameters)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.IBECORP_IMPORT_KZ_BOOKING_PARAMS);
        String pnr = parameters.getOrderNumber();
        EntityContainer gdsAccountCtr = EntityStorage.get().resolve(parameters.getGdsAccount());
        GdsName gds = ((KzRailGdsAccount)gdsAccountCtr.getEntity()).getGds();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.contains((String)BookingFileIndex.Property.gdsNames.name(), (Object)gds));
        query.getCriteria().getCriterions().add(SearchQueryHelper.getBookingRecordLocatorSearchCriterion((String)pnr));
        query.getPreferredProperties().add(BookingFileIndex.Property.fullNumber.name());
        List indexes = EntityStorage.get().search(BookingFileIndex.class, query).getData();
        if (indexes.size() > 1) {
            String bookingNumbers = indexes.stream().map(BookingFileIndex::getFullNumber).collect(Collectors.joining(","));
            throw Xeption.forEndUser((String)"\u041d\u0430\u0439\u0434\u0435\u043d\u043e \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0437\u0430\u043a\u0430\u0437\u043e\u0432 \u0441 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u043c \u043d\u043e\u043c\u0435\u0440\u043e\u043c \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f: {0}", (Object[])new Object[]{bookingNumbers});
        }
        EntityContainer bookingCtr = null;
        Reservation reservation = null;
        if (indexes.size() == 1) {
            bookingCtr = EntityStorage.get().resolve(((BookingFileIndex)indexes.get(0)).getSource());
            reservation = BookingHelper.findReservation((BookingFile)((BookingFile)bookingCtr.getEntity()), (String)pnr);
            BookingFileOperationParameters bookingOperationParams = (BookingFileOperationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_OPERATION_PARAMETERS);
            bookingOperationParams.setSaveBookingFile(false);
        } else {
            BookingFile booking = new BookingFile();
            booking.setDraftState(true);
            booking.setCreateDate(new Date());
            reservation = new Reservation();
            reservation.getGdsNameInfo().setOnlineGdsAccount(gdsAccountCtr.toReference());
            CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)reservation, (GdsName)((KzRailGdsAccount)gdsAccountCtr.getEntity()).getGds(), (RecordLocatorType)RecordLocatorType.DEFAULT, (String)pnr);
            BookingHelper.addReservation((BookingFile)booking, (Reservation)reservation);
            bookingCtr = EntityContainer.create((BaseEntity)booking);
            ctx.putObject((Enum)IBusRailKzContextKeys.KZ_IMPORT_TASK, (Object)Boolean.TRUE);
        }
        ctx.putObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE, (Object)bookingCtr);
        ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATION, (Object)reservation);
        ctx.putObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT, (Object)gdsAccountCtr);
    }
}

