/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.syncReservation;

import com.gridnine.bof.midoffice.ibus.BookingFileOperationParameters;
import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.exception.KzNotSaveImportedBookingException;
import com.gridnine.xtrip.common.incidents.IncidentsHelper;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;

public class KzImportExceptionHandler
extends BaseAdvice {
    public boolean handleException(Throwable e, MessageContext ctx) throws Exception {
        if (e instanceof KzNotSaveImportedBookingException) {
            BookingFileOperationParameters parameters = new BookingFileOperationParameters();
            parameters.setSaveBookingFile(false);
            parameters.setSaveSysLog(false);
            ctx.putObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_OPERATION_PARAMETERS, (Object)parameters);
            Collection docs = (Collection)ctx.getObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_DOCUMENTS);
            if (CollectionUtil.isNotEmpty((Collection)docs)) {
                docs.stream().filter(Document.class::isInstance).map(Document.class::cast).filter(doc -> doc.getType() == DocumentType.GDS_LOG).forEach(doc -> this.enrichStackTrace(e, (Document)doc));
                docs.clear();
            }
            ctx.getMessagesReadOnly().forEach(mes -> this.enrichStackTrace(e, (Message)mes));
            ctx.clearMessages();
        }
        return false;
    }

    private void enrichStackTrace(Throwable e, Document doc) {
        IncidentsHelper.addStackTraceElement((Throwable)e, (StackTraceElement[])new StackTraceElement[]{IncidentsHelper.getContextStackTraceElement((String)doc.getName(), (String)new String(doc.getContent()))});
    }

    private void enrichStackTrace(Throwable e, Message mes) {
        IncidentsHelper.addStackTraceElement((Throwable)e, (StackTraceElement[])new StackTraceElement[]{IncidentsHelper.getContextStackTraceElement((String)mes.getMessage().toString(), (String)mes.getDetails())});
    }
}

