/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.syncReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.KzRailGdsAccount;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.railway.CarriageType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.BookingStreamHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.PersonalName;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.RzdHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.IBusRailKzContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.KzHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.model.GetOrderStatusRS;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.model.common.Passenger;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.model.common.TariffType;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.railway.model.helpers.RzdServiceConverter;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.Date;
import org.apache.commons.lang.BooleanUtils;

public class KzRailwayReservationBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        GetOrderStatusRS response = (GetOrderStatusRS)ctx.getMandatoryObject((Enum)IBusRailKzContextKeys.KZ_GET_ORDER_STATUS_RESPONSE);
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        boolean isImportTask = BooleanUtils.isTrue((Boolean)((Boolean)ctx.getObject((Enum)IBusRailKzContextKeys.KZ_IMPORT_TASK)));
        Reservation resultReservation = null;
        if (isImportTask) {
            resultReservation = reservation;
        } else {
            resultReservation = new Reservation();
            ctx.putObject((Enum)IBusRailKzContextKeys.KZ_RESERVATION, (Object)resultReservation);
        }
        this.updateReservation(resultReservation, response, (KzRailGdsAccount)accountCtr.getEntity());
        if (isImportTask) {
            BookingFile booking = resultReservation.getBookingFile();
            BookingStreamHelper.getProductsStream((Reservation)resultReservation, RailwayProduct.class).flatMap(rp -> rp.getPassengers().stream()).distinct().forEach(booking.getTravellers()::add);
        }
    }

    private void updateReservation(Reservation reservation, GetOrderStatusRS response, KzRailGdsAccount gdsAccount) {
        reservation.setResDate(KzHelper.convertZonedDateFromGds(response.getOrderInfo().getOrderCreateDate(), gdsAccount));
        for (GetOrderStatusRS.TicketStatus gdsTicket : response.getTicketsStatuses()) {
            RailwayProduct product = this.createProduct(gdsTicket, response, gdsAccount);
            BookingHelper.addProduct((Reservation)reservation, (BaseProduct)product);
        }
    }

    private RailwayProduct createProduct(GetOrderStatusRS.TicketStatus gdsTicket, GetOrderStatusRS response, KzRailGdsAccount gdsAccount) {
        RailwayProduct product = new RailwayProduct();
        product.setTicketType(TicketType.OWN);
        product.setEticket(true);
        product.setIssueDate(new Date());
        product.setStatus(ProductStatus.BOOKING);
        DictionaryReference passengerTypeRef = gdsTicket.getTariffType() == TariffType.KID ? DictHelper.getChildPassengerType() : DictHelper.getAdultPassengerType();
        gdsTicket.getPassengers().stream().map(this::buildTraveller).forEach(tr -> {
            RailwayProductHelper.setPassengerType((RailwayProduct)product, (Traveller)tr, (DictionaryReference)passengerTypeRef);
            product.getPassengers().add(tr);
        });
        product.setBlankId(KzHelper.buildBlankId("", gdsTicket.getTicketId()));
        product.setExpressId(gdsTicket.getExpressID());
        String gdsCurrency = gdsAccount.getCurrency() == null ? null : gdsAccount.getCurrency().getCode();
        product.setGdsCurrency(gdsCurrency);
        BigDecimal totalFare = gdsTicket.getTariff();
        product.setEquivalentFare(totalFare);
        product.setTotalEquivalentFare(totalFare);
        CarriageType carriageType = KzHelper.convertCarriageTypeFromGds(response.getOrderInfo().getCarType());
        RailwaySegment segment = new RailwaySegment();
        segment.setNumber(1);
        segment.setDepartureDate(DateUtils.toJavaDate((LocalDateTime)response.getOrderInfo().getDepartureDateTime()));
        segment.setArriveDate(DateUtils.toJavaDate((LocalDateTime)response.getOrderInfo().getArrivalDateTime()));
        segment.setTrainArriveToStationDate(segment.getArriveDate());
        segment.setTrainArriveToStationLocalDate(segment.getLocalArriveDate());
        RzdHelper.writeFullTrainNumber(segment, response.getOrderInfo().getDepartureTrainNumber());
        segment.setCarriageNumber(response.getOrderInfo().getCarNumber());
        segment.getPlaces().addAll(Collections.singleton(gdsTicket.getSeats()));
        segment.setCarriageType(carriageType);
        segment.setServiceClass(RzdServiceConverter.getServiceClassByName((String)response.getOrderInfo().getCarClassService()));
        product.getSegments().add(segment);
        return product;
    }

    private Traveller buildTraveller(Passenger gdsPassenger) {
        Traveller result = new Traveller();
        Passport psp = new Passport();
        if (TextUtil.nonBlank((String)gdsPassenger.getName())) {
            String doc = gdsPassenger.getDoc();
            String docType = doc.substring(0, 2);
            String docNumber = doc.substring(2);
            psp.setType(KzHelper.convertPassportTypeFromGdsStr(docType));
            psp.setNumber(docNumber);
            String[] names = gdsPassenger.getName().split("=");
            psp.setLastName(names[0]);
            if (names.length > 1) {
                psp.setFirstName(names[1]);
            }
            if (names.length > 2) {
                psp.setMiddleName(names[2]);
            }
            psp.setBirthday(DateUtils.toJavaDate((LocalDateTime)gdsPassenger.getBirthDay()));
        }
        result.setPassport(psp);
        result.setName(TextUtil.buildFullName((PersonalName)psp));
        result.setBirthday(psp.getBirthday());
        return result;
    }
}

