/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.syncReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationStatus;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.IBusRailKzContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.KzHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.model.GetOrderStatusRS;
import com.gridnine.xtrip.server.ibus.components.BaseRoutingKeyProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

public class KzReservationStatusProvider
extends BaseRoutingKeyProvider {
    public String getRoutingKey(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        ProductStatus gdsStatus = (ProductStatus)ctx.getObject((Enum)IBusRailwayContextKeys.RAILWAY_PRODUCT_STATUS);
        if (gdsStatus == null) {
            GetOrderStatusRS response = (GetOrderStatusRS)ctx.getMandatoryObject((Enum)IBusRailKzContextKeys.KZ_GET_ORDER_STATUS_RESPONSE);
            gdsStatus = this.calcStatus(response);
            ctx.putObject((Enum)IBusRailwayContextKeys.RAILWAY_PRODUCT_STATUS, (Object)gdsStatus);
        }
        if (gdsStatus == null) {
            reservation.setStatus(ReservationStatus.ERROR);
            return null;
        }
        return gdsStatus.name();
    }

    private ProductStatus calcStatus(GetOrderStatusRS response) {
        Set gdsStatuses = response.getTicketsStatuses().stream().map(ts -> KzHelper.convertToProductStatus(ts.getState())).collect(Collectors.toSet());
        if (gdsStatuses.size() == 1) {
            return (ProductStatus)gdsStatuses.iterator().next();
        }
        if (gdsStatuses.size() == 2 && gdsStatuses.containsAll(Arrays.asList(ProductStatus.SELL, ProductStatus.REFUND))) {
            return ProductStatus.REFUND;
        }
        return null;
    }
}

