/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.ticketReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.KzRailGdsAccount;
import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.IBusRailKzContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.KzHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.KzOperation;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.KzRequestParameters;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.model.ConfirmCompleteRQ;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.time.LocalDateTime;

public class KzConfirmCompleteRequestBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        ctx.putObject((Enum)IBusRailKzContextKeys.KZ_REQUEST_PARAMS, (Object)new KzRequestParameters(KzOperation.ConfirmComplete).setRequest(this.buildRequest(reservation, (KzRailGdsAccount)accountCtr.getEntity())));
        ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u041d\u0430\u0447\u0430\u0442\u0430 \u0432\u044b\u043f\u0438\u0441\u043a\u0430 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f {0}", (Object[])new Object[]{CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation)}));
    }

    private ConfirmCompleteRQ buildRequest(Reservation reservation, KzRailGdsAccount gdsAccount) throws Exception {
        ConfirmCompleteRQ result = new ConfirmCompleteRQ();
        result.setOrderId(KzHelper.getOrderId(reservation));
        result.setMachineKey(gdsAccount.getMachineKey());
        for (RailwayProduct rp : RzdCommonHelper.getProducts((Reservation)reservation)) {
            ConfirmCompleteRQ.Ticket ticket = new ConfirmCompleteRQ.Ticket();
            ticket.setTicketId(KzHelper.getGdsId(rp.getBlankId()));
            ConfirmCompleteRQ.Payment payment = new ConfirmCompleteRQ.Payment();
            payment.setTerminal(gdsAccount.getTerminal());
            payment.setPaymentTimestamp(LocalDateTime.now());
            payment.setRequisite(rp.getExpressId());
            payment.setAmount(rp.getTotalEquivalentFare());
            payment.setComission(this.calcFees(rp));
            String content = KzHelper.MAPPER.writeValueAsString((Object)payment);
            payment.setSignature(KzHelper.calcSignature(content, gdsAccount));
            ticket.setPayment(payment);
            result.getTickets().add(ticket);
        }
        return result;
    }

    private BigDecimal calcFees(RailwayProduct rp) {
        GeneralProductContractRelationData cr = GeneralProductHelper.getContractRelation((BaseProduct)rp, (ContractType)ContractType.SUBAGENCY);
        if (cr == null) {
            cr = GeneralProductHelper.getContractRelation((BaseProduct)rp, (ContractType)ContractType.CLIENT);
        }
        if (cr == null) {
            return null;
        }
        BigDecimal result = BigDecimal.ZERO;
        for (GeneralProductCommission commission : cr.getCommissions()) {
            Money amount = commission.getAmount();
            if (amount == null) continue;
            if (!MiscUtil.equals((Object)amount.getCurrency(), (Object)rp.getGdsCurrency())) {
                throw Xeption.forDeveloper((String)"commission currency {0} != gds currency {1}", (Object[])new Object[]{amount.getCurrency(), rp.getGdsCurrency()});
            }
            result = MiscUtil.sum((BigDecimal[])new BigDecimal[]{result, amount.getValue()});
        }
        return result;
    }
}

