/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.ticketReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.KzRailGdsAccount;
import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.ibecorp.rzd.model.Fiscal;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.IBusPgContextKeys;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.IBusRailKzContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.KzHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.kz.model.ConfirmCompleteRS;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.time.ZonedDateTime;
import java.util.Date;

public class KzConfirmCompleteResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        ConfirmCompleteRS response = (ConfirmCompleteRS)ctx.getMandatoryObject((Enum)IBusRailKzContextKeys.KZ_RESPONSE);
        PaymentType paymentType = (PaymentType)ctx.getMandatoryObject((Enum)IBusPgContextKeys.PAYMENT_TYPE);
        this.ticketReservation(reservation, response, (KzRailGdsAccount)accountCtr.getEntity(), paymentType);
        ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0411\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 {0} \u0432\u044b\u043f\u0438\u0441\u0430\u043d\u043e", (Object[])new Object[]{CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation)}));
    }

    private void ticketReservation(Reservation reservation, ConfirmCompleteRS response, KzRailGdsAccount gdsAccount, PaymentType paymentType) {
        Date curDate = new Date();
        for (RailwayProduct rp : RzdCommonHelper.getProducts((Reservation)reservation)) {
            ConfirmCompleteRS.Ticket ticket = response.getTickets().stream().filter(t -> MiscUtil.equals((Object)rp.getExpressId(), (Object)t.getTicketId())).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"can't find reservation system ticket with expressId = {0}", (Object[])new Object[]{rp.getExpressId()}));
            rp.setStatus(ProductStatus.SELL);
            rp.setPaymentType(paymentType);
            rp.setIssueDate(curDate);
            rp.setSystemNumber(ticket.getTicketId());
            Date refundExpireDate = KzHelper.convertZonedDateFromGds(ticket.getStopDateTime(), gdsAccount);
            rp.setERegExpireDate(refundExpireDate);
            rp.setRefundExpireDate(refundExpireDate);
            rp.setBarcodeText(ticket.getPaymentInfo().getBarcodeText());
            Fiscal fiscal = new Fiscal();
            fiscal.setDate(DateUtils.toJavaDate((ZonedDateTime)ticket.getPaymentInfo().getFiscalDate()));
            fiscal.setNumber(ticket.getPaymentInfo().getFiscalNumber());
            fiscal.setDocumentNumber(ticket.getPaymentInfo().getFiscalDocumentNumber());
            rp.setFiscal(fiscal);
            RailwaySegment segment = RzdCommonHelper.getSegment((RailwayProduct)rp);
            segment.setHasEReg(ticket.isElRegStatus());
            RailwayProductHelper.updateFops((RailwayProduct)rp);
        }
    }
}

