/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.ufs;

import com.gridnine.xtrip.common.ibecorp.exception.NeedSetErrorBookingStatusException;
import com.gridnine.xtrip.common.ibecorp.exception.NoTrainsException;
import com.gridnine.xtrip.common.ibecorp.exception.TooOftenException;
import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GdsErrorTranslator {
    private static final Map<Pattern, Xeption> MESSAGE_XEPTIONS = new HashMap<Pattern, Xeption>();
    private static final Map<String, String> DESCR_ID_USER_MESSAGES;
    private static final Map<Pattern, String> USER_MESSAGES;

    public Xeption translate(String gdsDescrId, String gdsError) {
        Xeption xeption = this.findMatchesXeption(gdsError);
        if (xeption != null) {
            return xeption;
        }
        L10nMessage userMessage = null;
        String userMessageText = DESCR_ID_USER_MESSAGES.get(gdsDescrId);
        if (!TextUtil.isBlank((String)userMessageText)) {
            userMessage = L10nResourcesManager.createL10nMessage((String)userMessageText, (Object[])new Object[0]);
        }
        if (userMessage == null) {
            userMessage = this.findMatchesMessageWithArgs(gdsError);
        }
        if (userMessage != null) {
            return new Xeption(userMessage, null, null, null);
        }
        return Xeption.forDeveloper((String)gdsError, (Object[])new Object[0]);
    }

    private Xeption findMatchesXeption(String text) {
        if (TextUtil.isBlank((String)text)) {
            return null;
        }
        for (Map.Entry<Pattern, Xeption> entry : MESSAGE_XEPTIONS.entrySet()) {
            Matcher m = entry.getKey().matcher(text);
            if (!m.find()) continue;
            return entry.getValue();
        }
        return null;
    }

    private L10nMessage findMatchesMessageWithArgs(String text) {
        if (TextUtil.isBlank((String)text)) {
            return null;
        }
        for (Map.Entry<Pattern, String> entry : USER_MESSAGES.entrySet()) {
            Matcher m = entry.getKey().matcher(text);
            if (!m.find()) continue;
            Object[] args = new String[m.groupCount()];
            for (int i = 0; i < m.groupCount(); ++i) {
                args[i] = m.group(i + 1);
            }
            return L10nResourcesManager.createL10nMessage((String)entry.getValue(), (Object[])args);
        }
        return null;
    }

    static {
        MESSAGE_XEPTIONS.put(Pattern.compile("\u0412 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u0443\u044e \u0434\u0430\u0442\u0443 \u043f\u043e\u0435\u0437\u0434\u043e\u0432 \u043d\u0435\u0442", 16), (Xeption)new NoTrainsException());
        MESSAGE_XEPTIONS.put(Pattern.compile("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b\u0430\u0441\u044c \u043d\u0435\u0443\u0441\u043f\u0435\u0448\u043d\u043e: \u0412\u041e\u0417\u0412\u0420\u0410\u0422 \u0412\u0421\u0415\u0413\u041e \u0417\u0410\u041a\u0410\u0417\u0410 \u041d\u0415 \u0412\u041e\u0417\u041c\u041e\u0416\u0415\u041d", 16), (Xeption)new NeedSetErrorBookingStatusException("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b\u0430\u0441\u044c \u043d\u0435\u0443\u0441\u043f\u0435\u0448\u043d\u043e: \u0412\u041e\u0417\u0412\u0420\u0410\u0422 \u0412\u0421\u0415\u0413\u041e \u0417\u0410\u041a\u0410\u0417\u0410 \u041d\u0415 \u0412\u041e\u0417\u041c\u041e\u0416\u0415\u041d"));
        MESSAGE_XEPTIONS.put(Pattern.compile("\u043e\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043b\u044f\u0442\u044c \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0443 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043d\u0435 \u0447\u0430\u0449\u0435", 16), (Xeption)new TooOftenException());
        DESCR_ID_USER_MESSAGES = new HashMap<String, String>();
        DESCR_ID_USER_MESSAGES.put("5380", "RAILWAY_MESSAGE_COMMUNICATION_ERROR_RETRY_THE_REQUEST");
        USER_MESSAGES = new HashMap<Pattern, String>();
        USER_MESSAGES.put(Pattern.compile("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u0432\u044f\u0437\u0438. \u041f\u043e\u0432\u0442\u043e\u0440\u0438\u0442\u0435 \u0437\u0430\u043f\u0440\u043e\u0441", 16), "RAILWAY_MESSAGE_COMMUNICATION_ERROR_RETRY_THE_REQUEST");
        USER_MESSAGES.put(Pattern.compile(".*\u0417\u0410\u041f\u0420\u041e\u0421 \u041d\u0415 \u041c\u041e\u0416\u0415\u0422 \u0411\u042b\u0422\u042c \u0412\u042b\u041f\u041e\u041b\u041d\u0415\u041d\\s*\u0418\u0417-\u0417\u0410 \u041e\u0422\u0421\u0423\u0422\u0421\u0422\u0412\u0418\u042f \u0418\u041d\u0424\u041e\u0420\u041c\u0410\u0426\u0418\u0418 \u041e\u0422 \u0414\u0420\u0423\u0413\u041e\u0419 \u0416\u0415\u041b.\u0414\u041e\u0420\u041e\u0413\u0418.*"), "RAILWAY_MESSAGE_PROVIDER_ERROR_RETRY_THE_REQUEST");
        USER_MESSAGES.put(Pattern.compile("\u0421\u0435\u0440\u0432\u0438\u0441 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d", 16), "RAILWAY_MESSAGE_THE_SERVICE_IS_TEMPORARILY_UNAVAILABLE_TRY_THE_REQUEST_AGAIN");
        USER_MESSAGES.put(Pattern.compile("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b\u0430\u0441\u044c \u043d\u0435\u0443\u0441\u043f\u0435\u0448\u043d\u043e: \u0414\u0410\u041d\u041d\u0423\u042e \u041e\u041f\u0415\u0420\u0410\u0426\u0418\u042e \u0412\u042b\u041f\u041e\u041b\u041d\u042f\u0422\u042c \u041f\u041e\u0417\u0414\u041d\u041e.?"), "RAILWAY_MESSAGE_THIS_OPERATION_IS_PERFORMED_LATE");
        USER_MESSAGES.put(Pattern.compile("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b\u0430\u0441\u044c \u043d\u0435\u0443\u0441\u043f\u0435\u0448\u043d\u043e.* \u041e\u0428 (T|\u0412|B).?"), "RAILWAY_MESSAGE_ERROR_REQUIREMENTS_TRY_AGAIN_OR_CHANGE_TO_PLACES_REQUIREMENTS");
        USER_MESSAGES.put(Pattern.compile("\u041d\u0415\u0422_\u042d\u0412\u0426_.{1}"), "RAILWAY_MESSAGE_REPEAT_REQUEST");
        USER_MESSAGES.put(Pattern.compile("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b\u0430\u0441\u044c \u043d\u0435\u0443\u0441\u043f\u0435\u0448\u043d\u043e.* \u041d\u0415\u0422 \u042d\u0412\u0426.*"), "RAILWAY_MESSAGE_REPEAT_REQUEST");
        USER_MESSAGES.put(Pattern.compile("\u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438: \u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u043d\u0430 \u0431\u0430\u043b\u0430\u043d\u0441\u0435", 16), "RAILWAY_MESSAGE_AUTHORIZATION_ERROR_INSUFFICIENT_FUNDS");
        USER_MESSAGES.put(Pattern.compile("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b\u0430\u0441\u044c \u043d\u0435\u0443\u0441\u043f\u0435\u0448\u043d\u043e.*: \u041d\u0417\\s*"), "RAILWAY_MESSAGE_OPERATION_FAILED");
        USER_MESSAGES.put(Pattern.compile("\u041e\u0448\u0438\u0431\u043e\u0447\u043d\u044b\u0439 \u0437\u0430\u043f\u0440\u043e\u0441", 16), "RAILWAY_MESSAGE_ERROR_TRY_TO_REPEAT_THE_REQUEST");
        USER_MESSAGES.put(Pattern.compile("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u0430 \u0434\u0430\u0442\u0430 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043f\u043e\u0435\u0437\u0434\u0430.*"), "RAILWAY_MESSAGE_ERROR_TRY_TO_REPEAT_THE_REQUEST_OR_CALL_SUPPORT");
        USER_MESSAGES.put(Pattern.compile("\u0414\u043b\u044f \u0433\u0440\u0443\u043f\u043f\u043e\u0432\u044b\u0445 \u043f\u043e\u0435\u0437\u0434\u043e\u043a \u0437\u0430\u043a\u0430\u0437 \u0431\u0438\u043b\u0435\u0442\u043e\u0432 \u0447\u0435\u0440\u0435\u0437 \u0418\u043d\u0442\u0435\u0440\u043d\u0435\u0442 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d", 16), "RAILWAY_MESSAGE_FOR_GROUP_TRAVEL_TICKETS_THROUGH_THE_INTERNET_IS_NOT_POSSIBLE");
        USER_MESSAGES.put(Pattern.compile("\u041f\u0440\u0438\u043e\u0431\u0440\u0435\u0441\u0442\u0438 \u0431\u0438\u043b\u0435\u0442 \u043d\u0430 \u0434\u0430\u043d\u043d\u044b\u0439 \u043f\u043e\u0435\u0437\u0434 \u0447\u0435\u0440\u0435\u0437 \u0418\u043d\u0442\u0435\u0440\u043d\u0435\u0442-\u0441\u0438\u0441\u0442\u0435\u043c\u0443 \u0432 \u043d\u0430\u0441\u0442\u043e\u044f\u0449\u0438\u0439 \u043c\u043e\u043c\u0435\u043d\u0442 \u043d\u0435 \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u044b\u043c! \u041f\u0440\u0438\u043d\u043e\u0441\u0438\u043c \u0412\u0430\u043c \u0441\u0432\u043e\u0438 \u0438\u0437\u0432\u0438\u043d\u0435\u043d\u0438\u044f", 16), "RAILWAY_MESSAGE_BUY_A_TICKET_FOR_THE_TRAIN_THROUGH_THE_INTERNET_SYSTEM_IS_CURRENTLY_NOT_POSSIBLE");
        USER_MESSAGES.put(Pattern.compile("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u043d\u043e\u043c\u0435\u0440\u0430 \u043f\u043e\u0435\u0437\u0434\u0430", 16), "RAILWAY_MESSAGE_INVALID_FORMAT_OF_TRAIN_NUMBERS");
        USER_MESSAGES.put(Pattern.compile("\u041f\u043e \u043e\u0434\u043d\u043e\u0439 \u043b\u044c\u0433\u043e\u0442\u0435 \u0434\u0432\u0430 \u043f\u0440\u043e\u0435\u0437\u0434\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 \u043e\u0444\u043e\u0440\u043c\u043b\u044f\u0442\u044c \u043d\u0435\u043b\u044c\u0437\u044f", 16), "RAILWAY_MESSAGE_TWO_OF_THE_TRAVEL_DOCUMENT_CAN_NOT_BE_ADJUSTED_BY_ONE_PRIVILEGE");
        USER_MESSAGES.put(Pattern.compile("\u0412 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u0443\u044e \u0434\u0430\u0442\u0443 \u043f\u043e\u0435\u0437\u0434\u043e\u0432 \u043d\u0435\u0442", 16), "RAILWAY_MESSAGE_AT_THE_SPECIFIED_DATE_NO_TRAINS");
        USER_MESSAGES.put(Pattern.compile("\u041f\u043e \u0434\u0430\u043d\u043d\u044b\u043c \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u044f\u043c \u043c\u0435\u0441\u0442 \u043d\u0435\u0442, \u043f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u044f \u043a \u043c\u0435\u0441\u0442\u0430\u043c", 16), "RAILWAY_MESSAGE_ACCORDING_TO_THE_REQUIREMENTS_NO_SEATS_TRY_TO_CHANGE_TO_PLACES_REQUIREMENTS");
        USER_MESSAGES.put(Pattern.compile("\u041d\u0430 \u0437\u0430\u0434\u0430\u043d\u043d\u043e\u043c \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0438 (\u0438\u043b\u0438 \u043f\u043e\u0435\u0437\u0434\u0435) \u043c\u0435\u0441\u0442 \u043d\u0435\u0442", 16), "RAILWAY_MESSAGE_ON_A_GIVEN_DIRECTION_OR_TRAIN_NO_SEATSEMENTS");
        USER_MESSAGES.put(Pattern.compile("\u0412 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u043e\u043c \u0432\u0430\u0433\u043e\u043d\u0435 \u0441\u0432\u043e\u0431\u043e\u0434\u043d\u044b\u0445 \u043c\u0435\u0441\u0442 \u043d\u0435\u0442", 16), "RAILWAY_MESSAGE_THE_SELECTED_CAR_AVAILABILITY_IS_NOT");
        USER_MESSAGES.put(Pattern.compile("\u041d\u0435\u0442 \u0432 \u043e\u0434\u043d\u043e\u043c \u043a\u0443\u043f\u0435.?"), "RAILWAY_MESSAGE_IN_ONE_COMPARTMENT_NO_SEATS");
        USER_MESSAGES.put(Pattern.compile("\u041d\u0438\u0436\u043d\u0438\u0445 \u043d\u0435\u0442 \u0438\u043b\u0438 \u0443 \u043e\u043a\u043d\u0430.?"), "RAILWAY_MESSAGE_NO_LOWER_SEATS_OR_NEAR_WINDOW");
        USER_MESSAGES.put(Pattern.compile(".*\u041d\u0418\u0416\u041d\u0418\u0425 \u041d\u0415\u0422 \\(\u0418\u041b\u0418 \u0423 \u041e\u041a\u041d\u0410\\).*"), "RAILWAY_MESSAGE_NO_LOWER_SEATS_OR_NEAR_WINDOW");
        USER_MESSAGES.put(Pattern.compile(".*\u041d\u0435\u0442 \u043d\u0438\u0436\u043d\u0438\u0445 \u043c\u0435\u0441\u0442 \u0438\u043b\u0438 \u0443 \u043e\u043a\u043d\u0430.*"), "RAILWAY_MESSAGE_NO_LOWER_SEATS_OR_NEAR_WINDOW");
        USER_MESSAGES.put(Pattern.compile("(\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b\u0430\u0441\u044c \u043d\u0435\u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043d\u0430 \u0441\u0442\u043e\u0440\u043e\u043d\u0435 \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440\u0430. )?\u0412\u0435\u0440\u0445\u043d\u0438\u0445 \u043d\u0435\u0442.?", 66), "RAILWAY_MESSAGE_TOP_SEATS_NO");
        USER_MESSAGES.put(Pattern.compile("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0435 \u041c/\u0416.?"), "RAILWAY_SPECIFY_REQUIREMENT_MF");
        USER_MESSAGES.put(Pattern.compile(".*\u0423\u041a\u0410\u0416\u0418\u0422\u0415 \u0422\u0420\u0415\u0411\u041e\u0412\u0410\u041d\u0418\u042f \u041c/\u0416"), "RAILWAY_CHANGED_KUPE_GENDER");
        USER_MESSAGES.put(Pattern.compile("\u041d\u0435\u0442 \u043c\u0435\u0441\u0442 \u043f\u043e \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u043c \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u044f\u043c"), "RAILWAY_MESSAGE_NO_SEATS");
        USER_MESSAGES.put(Pattern.compile("\u041d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u0431\u043e\u043d\u0443\u0441\u043d\u043e\u0439 \u043a\u0430\u0440\u0442\u044b.?"), "RAILWAY_MESSAGE_INVALID_NUMBER_OF_BONUS_CARDS");
        USER_MESSAGES.put(Pattern.compile("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b\u0430\u0441\u044c \u043d\u0435\u0443\u0441\u043f\u0435\u0448\u043d\u043e: KAPTA HE \u0414E\u0419CTB\u0423ET \u0414\u041b\u042f \\s*\u0417A\u0414AHHO\u0413O \u041b\u0418\u0427HO\u0413O \u0414OK\u0423MEHTA\\s*"), "RAILWAY_MESSAGE_THE_CARD_IS_NOT_VALID_FOR_THE_SPECIFIED_PERSONAL_DOCUMENT");
        USER_MESSAGES.put(Pattern.compile("\u0411\u043e\u043d\u0443\u0441\u043d\u0430\u044f \u043a\u0430\u0440\u0442\u0430 \u043d\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u0430 \u0434\u043b\u044f \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u0433\u043e \u043b\u0438\u0447\u043d\u043e\u0433\u043e \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430"), "RAILWAY_MESSAGE_THE_CARD_IS_NOT_VALID_FOR_THE_SPECIFIED_PERSONAL_DOCUMENT");
        USER_MESSAGES.put(Pattern.compile("\u0424\u0418\u041e \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u0430 \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u0434\u0430\u043d\u043d\u044b\u043c \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u043a\u0430\u0440\u0442\u044b!", 16), "RAILWAY_MESSAGE_THE_NAME_OF_THE_PASSENGER_DOES_NOT_CONFORM_TO_CARDHOLDER_DATA");
        USER_MESSAGES.put(Pattern.compile("\u0423\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u0430 \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u044e\u0442 \u0441 \u0434\u0430\u043d\u043d\u044b\u043c\u0438 \u0432 \u0431\u043e\u043d\u0443\u0441\u043d\u043e\u0439 \u043a\u0430\u0440\u0442\u0435.*"), "RAILWAY_MESSAGE_THE_PASSENGER_DATA_DOES_NOT_CONFORM_TO_CARD_DATA");
        USER_MESSAGES.put(Pattern.compile("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b\u0430\u0441\u044c \u043d\u0435\u0443\u0441\u043f\u0435\u0448\u043d\u043e: TAP\u0418\u0424H\u042b\u0419 \u041f\u041bAH KAPT\u042b\\s+HE COOTBETCTB\u0423ET HA\u0411OP\u0423\\s*"), "RAILWAY_MESSAGE_INCORRECT_CARD_NUMBER");
        USER_MESSAGES.put(Pattern.compile("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b\u0430\u0441\u044c \u043d\u0435\u0443\u0441\u043f\u0435\u0448\u043d\u043e: TAP\u0418\u0424H\u042b\u0419 \u041f\u041bAH KAPT\u042b\\s+HE \u0414E\u0419CTB\u0423ET HA \u0417A\u0414AHH\u0423\u042e \u0414AT\u0423\\s*"), "RAILWAY_MESSAGE_THE_TARIFF_PLAN_OF_THE_CARD_IS_NOT_VALID_FOR_THE_SPECIFIED_DATE");
        USER_MESSAGES.put(Pattern.compile("\u041d\u0435\u0432\u0435\u0440\u043d\u043e \u0432\u044b\u0431\u0440\u0430\u043d\u0430 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0430 \u043b\u043e\u044f\u043b\u044c\u043d\u043e\u0441\u0442\u0438", 16), "RAILWAY_MESSAGE_LOYALTY_PROGRAM_SETTING_IS_INCORRECT");
        USER_MESSAGES.put(Pattern.compile("TPE\u0411OBAH\u0418E B K\u041b\u042e\u0427E  T     HE COOTBETCTB\u0423ET \u041fO\u041b\u0423 \u041fACCA\u0416\u0418PA", 16), "RAILWAY_MESSAGE_PASSENGER_DATA_NOT_MATCH_BONUS_CARD_REQUIREMENTS");
        USER_MESSAGES.put(Pattern.compile("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u043d\u0430\u0431\u043e\u0440 \u043d\u043e\u043c\u0435\u0440\u0430 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430, \u0443\u0434\u043e\u0441\u0442\u043e\u0432\u0435\u0440\u044f\u044e\u0449\u0435\u0433\u043e \u043b\u0438\u0447\u043d\u043e\u0441\u0442\u044c.?"), "RAILWAY_MESSAGE_THE_DOCUMENT_DOES_NOT_COINCIDE_WITH_THE_NATIONALITY_OR_NUMBER_IS_ENTERED_INCORRECTLY");
        USER_MESSAGES.put(Pattern.compile("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u0433\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u0442\u0432\u043e \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u0430. \u041d\u043e\u043c\u0435\u0440 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 .*"), "RAILWAY_MESSAGE_CITIZENSHIP_PASSENGER_DOES_NOT_CONFORM_TO_THIS_DOCUMENT");
        USER_MESSAGES.put(Pattern.compile(".*B \u0424AM\u0418\u041b\u0418\u0418 \u0418 \u0418MEH\u0418 BCE\\s+\u0411\u0423KB\u042b \u0414.\u0411. \u041bAT\u0418HCK\u0418M\u0418.*"), "RAILWAY_MESSAGE_IN_THE_FIRST_AND_LAST_NAME_ALL_LETTERS_MUST_BE_IN_A_LATIN");
        USER_MESSAGES.put(Pattern.compile("\u041c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043d\u0435 \u0431\u043e\u043b\u044c\u0448\u0435 \u043f\u043e\u043b\u043e\u0432\u0438\u043d\u044b \u043d\u0438\u0436\u043d\u0438\u0445 \u043c\u0435\u0441\u0442 \u043e\u0442 \u043e\u0431\u0449\u0435\u0433\u043e \u0447\u0438\u0441\u043b\u0430 \u043c\u0435\u0441\u0442 \u0432 \u0437\u0430\u043a\u0430\u0437\u0435 \\(\u043f\u0440\u0438 \u043d\u0435\u0447\u0435\u0442\u043d\u043e\u043c \u0447\u0438\u0441\u043b\u0435 \u043e\u043a\u0440\u0443\u0433\u043b\u0435\u043d\u0438\u0435 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u043e \u0432 \u0431\u043e\u043b\u044c\u0448\u0443\u044e \u0441\u0442\u043e\u0440\u043e\u043d\u0443\\).*"), "RAILWAY_MESSAGE_IT_MAY_BE_NO_MORE_THAN_HALF_OF_THE_LOWER_SEATS_OF_THE_TOTAL_SEATS_IN_THE_ORDER");
        USER_MESSAGES.put(Pattern.compile(".*\u0414\u0415\u0422\u0421\u041a\u0418\u0419 \u0422\u041e\u041b\u042c\u041a\u041e \u041f\u041e \u041e\u0414\u041d\u041e\u041c\u0423 \u041c\u0415\u0421\u0422\u0423 \u041d\u0410 \u0411\u041b\u0410\u041d\u041a\u0415.*"), "RAILWAY_MESSAGE_CHILD_BY_ONE_BLANK");
        USER_MESSAGES.put(Pattern.compile("\u041f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 \u043f\u0440\u0438\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e \u043d\u0430 \u0432\u0440\u0435\u043c\u044f \u0442\u0435\u0445\u043d\u043e\u043b\u043e\u0433\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u043f\u0435\u0440\u0435\u0440\u044b\u0432\u0430 \u0441 (\\d+:\\d+) \u0434\u043e (\\d+:\\d+)"), "RAILWAY_MESSAGE_PAYMENTS_SUSPENDED_FOR_THE_PERIOD_OF_TECHNOLOGICAL_BREAK");
        USER_MESSAGES.put(Pattern.compile("\u041f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 \u043f\u0440\u0438\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e \u043d\u0430 \u0432\u0440\u0435\u043c\u044f \u043f\u0435\u0440\u0435\u0445\u043e\u0434\u0430 \u043c\u0435\u0441\u044f\u0446\u0430 \u0441 (\\d+:\\d+) \u0434\u043e (\\d+:\\d+)"), "RAILWAY_MESSAGE_PAYMENTS_SUSPENDED_DURING_THE_TRANSITION_MONTH_FROM_N_TO_M");
        USER_MESSAGES.put(Pattern.compile("\u041f\u043e\u0432\u0442\u043e\u0440\u043d\u043e\u0435 \u0440\u0435\u0437\u0435\u0440\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0441 \u0442\u0435\u043c\u0438 \u0436\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430\u043c\u0438 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0432 \u0442\u0435\u0447\u0435\u043d\u0438\u0435 (\\d+) \u043c\u0438\u043d\u0443\u0442([\u044b]?) \\(\u0441 \u043c\u043e\u043c\u0435\u043d\u0442\u0430 \u043f\u0435\u0440\u0432\u043e\u0433\u043e \u0437\u0430\u043a\u0430\u0437\u0430\\), \u043b\u0438\u0431\u043e \u0434\u043e \u043e\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043b\u0435\u043d\u0438\u044f \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430 \u043d\u0430 \u044d\u0442\u043e\u0442 \u0437\u0430\u043a\u0430\u0437"), "RAILWAY_MESSAGE_REPEATED_RESERVATION_WITH_THE_SAME_PARAMETERS_IS_IMPOSSIBLE_WITHIN_N_MINUTES");
        USER_MESSAGES.put(Pattern.compile("\u041e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u0435 \u0431\u0435\u0437\u0434\u0435\u043d\u0435\u0436\u043d\u044b\u0445 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u044b\u0445 \u0431\u0438\u043b\u0435\u0442\u043e\u0432 \u0434\u043b\u044f \u043f\u0440\u043e\u0435\u0437\u0434\u0430 \u0434\u0435\u0442\u0435\u0439 \u0434\u043e (\\d+) \u043b\u0435\u0442 \u0431\u0435\u0437 \u0437\u0430\u043d\u044f\u0442\u0438\u044f \u043e\u0442\u0434\u0435\u043b\u044c\u043d\u043e\u0433\u043e \u043c\u0435\u0441\u0442\u0430 \u041d\u0415 \u041f\u0420\u041e\u0418\u0417\u0412\u041e\u0414\u0418\u0422\u0421\u042f \u0441\u043e \u0441\u0442\u0430\u043d\u0446\u0438\u0439 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f, \u0440\u0430\u0441\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u043d\u044b\u0445 \u043d\u0430 \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u0438 (\\D+). \u0414\u043b\u044f \u0438\u0445 \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u044c\u0441\u044f \u0432 \u0436\u0435\u043b\u0435\u0437\u043d\u043e\u0434\u043e\u0440\u043e\u0436\u043d\u0443\u044e \u043a\u0430\u0441\u0441\u0443"), "RAILWAY_MESSAGE_BOOKING_E_TICKETS_FREE_OF_CHARGE_FOR_CHILDREN_UP_TO_N_YEARS_OF_AGE_WITHOUT_OCCUPYING_A_SEPARATE_SEAT_IS_NOT_PRODUCED");
        USER_MESSAGES.put(Pattern.compile("\u0414\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043f\u043e\u0435\u0437\u0434\u0430 \u043e\u0441\u0442\u0430\u043b\u043e\u0441\u044c \u043c\u0435\u043d\u044c\u0448\u0435 (\\d+:?\\d*) \u0447\u0430\u0441\u0430\\(-\u043e\u0432\\)."), "RAILWAY_MESSAGE_EARLY_TRAIN_DEPARTURE");
        USER_MESSAGES.put(Pattern.compile("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044e, \u0442.\u043a. \u0434\u0430\u043d\u043d\u0430\u044f \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f \u0443\u0436\u0435 \u0432 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043d\u043e\u043c \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0438"), "RAILWAY_MESSAGE_BOOKING_EXPIRED_TRY_LATER");
        USER_MESSAGES.put(Pattern.compile("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u0443\u044e \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044e. \u041f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u043f\u043e\u0437\u0434\u043d\u0435\u0435."), "RAILWAY_MESSAGE_EREG_FAILED_TRY_LATER");
        USER_MESSAGES.put(Pattern.compile("\u0411\u043e\u043d\u0443\u0441\u043d\u0430\u044f \u043a\u0430\u0440\u0442\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0430 \u043a \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u043c\u0443 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0443"), "RAILWAY_MESSAGE_INVALID_BONUS_CARD_DATA");
        USER_MESSAGES.put(Pattern.compile("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b\u0430\u0441\u044c \u043d\u0435\u0443\u0441\u043f\u0435\u0448\u043d\u043e: \u0412\u043e\u0437\u0440\u0430\u0441\u0442 \u043e\u0434\u043d\u043e\u0433\u043e \u0438\u0437 \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u043e\u0432 \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0437\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0435\u043c\u043e\u0439 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438"), "RAILWAY_MESSAGE_SOME_PASSENGER_AGE_NOT_CONFORMING");
    }
}

