/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.ufs;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.UfsGdsAccount;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.system.HttpRequest;
import com.gridnine.xtrip.common.model.system.RequestMethod;
import com.gridnine.xtrip.common.util.Base64;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.ufs.IBusUfsContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.ufs.UfsHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.ufs.UfsRequestParameters;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.ufs.UfsRequestUrlSuffix;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.http.IBusHttpContextKeys;
import java.util.Arrays;
import java.util.List;

public class UfsGateOldRequestBuilder
extends BaseProcessor {
    private static List<UfsRequestUrlSuffix> INFO_URLS = Arrays.asList(UfsRequestUrlSuffix.TimeTable, UfsRequestUrlSuffix.TrainList, UfsRequestUrlSuffix.TrainRoute, UfsRequestUrlSuffix.CarListEx);

    public void process(MessageContext ctx) throws Exception {
        UfsRequestParameters ufsParams = (UfsRequestParameters)ctx.getMandatoryObject((Enum)IBusUfsContextKeys.UFS_REQUEST_PARAMETERS);
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        UfsGdsAccount gdsAccount = (UfsGdsAccount)accountCtr.getEntity();
        if (gdsAccount.getAddress() == null) {
            throw Xeption.forAdmin((String)"\u041d\u0435 \u0437\u0430\u0434\u0430\u043d URL", (Object[])new Object[0]);
        }
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(gdsAccount.getAddress().toString() + "/" + this.getUrlSuffix(ufsParams.getUrlSuffix()));
        httpRequest.setBody(ufsParams.getRequestData().getBytes(UfsHelper.REQUEST_CHARSET));
        httpRequest.setRequestMethod(RequestMethod.POST);
        httpRequest.getRequestProperties().put((Object)"Connection", (Object)"close");
        String userPassword = gdsAccount.getAccount() + ":" + gdsAccount.getPassword();
        httpRequest.getRequestProperties().put((Object)"Authorization", (Object)("Basic " + Base64.encode((byte[])userPassword.getBytes())));
        httpRequest.setUseTrustfulHostnameVerifier(true);
        httpRequest.setUseTrustfulManager(true);
        if (gdsAccount.getTicketReadTimeoutSeconds() != null && ufsParams.getUrlSuffix() == UfsRequestUrlSuffix.ConfirmTicket) {
            httpRequest.setReadTimeout(Integer.valueOf(gdsAccount.getTicketReadTimeoutSeconds() * 1000));
        }
        ctx.putObject((Enum)IBusHttpContextKeys.HTTP_REQUEST, (Object)httpRequest);
        ctx.putObject((Enum)IBusRailwayContextKeys.RAILWAY_OPERATION, (Object)ufsParams.getUrlSuffix().getValue());
    }

    private String getUrlSuffix(UfsRequestUrlSuffix urlSuffix) {
        StringBuilder sb = new StringBuilder();
        if (INFO_URLS.contains((Object)urlSuffix)) {
            sb.append("GetInfo.asmx/");
        } else {
            sb.append("Tickets.asmx/");
        }
        sb.append(urlSuffix.getValue());
        return sb.toString();
    }
}

