/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.ufs;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.UfsGdsAccount;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.system.HttpRequest;
import com.gridnine.xtrip.common.model.system.RequestMethod;
import com.gridnine.xtrip.common.util.Base64;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.ufs.IBusUfsContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.ufs.UfsHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.ufs.UfsRequestParameters;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.ufs.UfsRequestUrlSuffix;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.http.IBusHttpContextKeys;

public class UfsGateRequestBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        UfsRequestParameters ufsParams = (UfsRequestParameters)ctx.getMandatoryObject((Enum)IBusUfsContextKeys.UFS_REQUEST_PARAMETERS);
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        UfsGdsAccount gdsAccount = (UfsGdsAccount)accountCtr.getEntity();
        if (gdsAccount.getAddress() == null) {
            throw Xeption.forAdmin((String)"\u041d\u0435 \u0437\u0430\u0434\u0430\u043d URL", (Object[])new Object[0]);
        }
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(gdsAccount.getAddress() + "/" + this.buildUrlSuffix(ufsParams));
        if (ufsParams.getRequestData() != null) {
            httpRequest.setBody(ufsParams.getRequestData().getBytes(this.getCharset(ufsParams.getUrlSuffix())));
        }
        httpRequest.setRequestMethod(ufsParams.getRequestData() != null ? RequestMethod.POST : RequestMethod.GET);
        httpRequest.getRequestProperties().put((Object)"Connection", (Object)"close");
        String userPassword = gdsAccount.getAccount() + ":" + gdsAccount.getPassword();
        httpRequest.getRequestProperties().put((Object)"Authorization", (Object)("Basic " + Base64.encode((byte[])userPassword.getBytes())));
        httpRequest.setUseTrustfulHostnameVerifier(true);
        httpRequest.setUseTrustfulManager(true);
        if (gdsAccount.getTicketReadTimeoutSeconds() != null && ufsParams.getUrlSuffix() == UfsRequestUrlSuffix.ConfirmTicket) {
            httpRequest.setReadTimeout(Integer.valueOf(gdsAccount.getTicketReadTimeoutSeconds() * 1000));
        }
        ctx.putObject((Enum)IBusHttpContextKeys.HTTP_REQUEST, (Object)httpRequest);
        ctx.putObject((Enum)IBusRailwayContextKeys.RAILWAY_OPERATION, (Object)ufsParams.getUrlSuffix().getValue());
    }

    private String getCharset(UfsRequestUrlSuffix operation) {
        return operation == UfsRequestUrlSuffix.BuyTicketXml ? "UTF-8" : UfsHelper.REQUEST_CHARSET;
    }

    private String buildUrlSuffix(UfsRequestParameters ufsParams) throws Exception {
        String result = ufsParams.getUrlSuffix().getValue();
        if (!ufsParams.getUrlParameters().isEmpty()) {
            result = result.concat("?").concat(UfsHelper.generateDatafromMap(ufsParams.getUrlParameters(), "UTF-8"));
        }
        return result;
    }
}

