/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.ufs;

import com.gridnine.xtrip.common.model.system.HttpResponse;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.RailwayHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.ufs.GdsErrorTranslator;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.ufs.IBusUfsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.http.IBusHttpContextKeys;
import org.w3c.dom.Element;

public class UfsGateResponseProcessor
extends BaseProcessor {
    public static final String ERROR_STATUS_CODE = "1";

    public void process(MessageContext ctx) throws Exception {
        HttpResponse httpResponse = (HttpResponse)ctx.getMandatoryObject((Enum)IBusHttpContextKeys.HTTP_RESPONSE);
        Element responseEl = RailwayHelper.getHttpResponseElement(httpResponse, this.isHaveToParseXml(httpResponse.getContentType()));
        this.checkGdsError(responseEl);
        ctx.putObject((Enum)IBusUfsContextKeys.UFS_RESPONSE_DATA, (Object)responseEl);
    }

    private void checkGdsError(Element responseEl) {
        if (this.isErrorStatus(responseEl)) {
            String descrIdTag = XHelper.readString((Element)responseEl, (String)"DescrId");
            throw new GdsErrorTranslator().translate(descrIdTag, this.extractGdsErrorMessage(responseEl));
        }
    }

    private String extractGdsErrorMessage(Element responseEl) {
        String descrTag = XHelper.readString((Element)responseEl, (String)"Descr");
        String errorTag = XHelper.readString((Element)responseEl, (String)"Error");
        if (TextUtil.isBlank((String)errorTag)) {
            return descrTag;
        }
        return descrTag + ". " + errorTag;
    }

    private boolean isErrorStatus(Element responseEl) {
        return ERROR_STATUS_CODE.equals(XHelper.readString((Element)responseEl, (String)"Status"));
    }

    private boolean isHaveToParseXml(String contentType) {
        if (TextUtil.isBlank((String)contentType)) {
            return false;
        }
        return contentType.indexOf("/xml") != -1;
    }
}

