/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.ufs;

import com.gridnine.xtrip.common.ibecorp.rzd.model.KupeIndication;
import com.gridnine.xtrip.common.ibecorp.rzd.model.MovementDirection;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdAbstractSearchParameters;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdSearchWithTimeParameters;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTariff;
import com.gridnine.xtrip.common.midoffice.helper.ReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.PassengerTypeValue;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.railway.CarriageType;
import com.gridnine.xtrip.common.model.booking.railway.CompartmentType;
import com.gridnine.xtrip.common.model.dict.DictPredifinedValueProvider;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.RailwayHelper;
import com.gridnine.xtrip.server.ibecorp.rzd.model.RefundTransactionInfo;
import com.gridnine.xtrip.server.ibecorp.ufs.model.domain.BlankInfo;
import com.gridnine.xtrip.server.ibecorp.ufs.util.UfsUtil;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;

public class UfsHelper {
    public static String REQUEST_CHARSET = "cp1251";
    public static String RESPONSE_CHARSET = "UTF-8";
    private static String dateFormat = "dd.MM.yyyy";
    private static Map<CarriageType, String> carriageTypeMap = new HashMap<CarriageType, String>();
    private static Map<CompartmentType, String> compartmentTypeMap;
    private static Map<KupeIndication, Integer> kupeIndicationMap;
    private static Map<Gender, String> genderMap;
    private static Map<PassportType, String> passportTypeMap;
    private static Map<RzdTariff, String> tariffsMap;
    private static Map<PassengerTypeValue, String[]> passengerTypeMap;
    private static Map<MovementDirection, String> movementDirectionMap;
    private static Map<ContentType, String> contentTypeMap;

    public static String generateDatafromMap(Map<String, String> map) throws Exception {
        return UfsHelper.generateDatafromMap(map, REQUEST_CHARSET);
    }

    public static String generateDatafromMap(Map<String, String> map, String charset) throws Exception {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (sb.length() != 0) {
                sb.append("&");
            }
            sb.append(entry.getKey()).append("=").append(entry.getValue() == null ? "" : URLEncoder.encode(entry.getValue(), charset));
        }
        return sb.toString();
    }

    public static String getTransId(Reservation reservation) {
        return ReservationGdsNameInfoHelper.getOnlineRecordLocator((Reservation)reservation, (RecordLocatorType)RecordLocatorType.DEFAULT);
    }

    public static Integer convertToSeconds(String value) {
        if (value == null) {
            return null;
        }
        String[] values = value.split(":");
        if (values.length != 2) {
            throw new RuntimeException("Invalid format for time duration: " + value);
        }
        int seconds = Integer.valueOf(values[1]) * 60 + Integer.valueOf(values[0]) * 60 * 60;
        return seconds;
    }

    public static Date addTimeToDate(Date date, String time) throws Exception {
        if (date == null) {
            return null;
        }
        return UfsHelper.getDateTime(new SimpleDateFormat(dateFormat).format(MiscUtil.clearTime((Date)date)), time);
    }

    public static Date getDateTime(String date, String time) throws Exception {
        if (TextUtil.isBlank((String)date)) {
            return null;
        }
        return TextUtil.isBlank((String)time) ? UfsHelper.getDate(date) : UfsHelper.getDateTime(date + " " + time);
    }

    public static Date getDateTime(String datetime) throws Exception {
        return new SimpleDateFormat(dateFormat + " HH:mm").parse(datetime);
    }

    public static Date getDate(String date) throws Exception {
        return new SimpleDateFormat(dateFormat).parse(date);
    }

    public static boolean existsAsTrue(Element el, String tag) {
        return XmlUtil.getElement((Element)el, (String)tag) != null;
    }

    public static Integer booleanToInt(boolean value) {
        return value ? Integer.valueOf(1) : Integer.valueOf(0);
    }

    public static void fillRzdAbstractSearchParametersMap(RzdAbstractSearchParameters params, Map<String, String> map) {
        map.put("From", params.getDeparture().getCode());
        map.put("To", params.getArrival().getCode());
        map.put("Day", UfsUtil.getDayFromDate(params.getDepartureDate()));
        map.put("Month", UfsUtil.getMonthFromDate(params.getDepartureDate()));
    }

    public static void fillRzdSearchWithTimeParametersMap(RzdSearchWithTimeParameters params, Map<String, String> map) {
        UfsHelper.fillRzdAbstractSearchParametersMap((RzdAbstractSearchParameters)params, map);
        RailwayHelper.updateTimeRange(params);
        map.put("Time_sw", "1");
        map.put("Time_from", String.valueOf(params.getTimeFrom()));
        map.put("Time_to", String.valueOf(params.getTimeTo()));
    }

    public static String convertCarriageTypeToGds(CarriageType ct) {
        return carriageTypeMap.get(ct);
    }

    public static CarriageType convertCarriageTypeFromGds(String text) {
        if (TextUtil.isBlank((String)text)) {
            return null;
        }
        return (CarriageType)CollectionUtil.getKeyByValue(carriageTypeMap, (Object)text.substring(0, 1));
    }

    public static String convertCompartmentTypeToGds(CompartmentType ct) {
        return compartmentTypeMap.get(ct);
    }

    public static CompartmentType convertCompartmentTypeFromGds(String gdsValue) {
        return (CompartmentType)CollectionUtil.getKeyByValue(compartmentTypeMap, (Object)gdsValue);
    }

    public static Integer convertKupeIndicationToGds(KupeIndication value) {
        return kupeIndicationMap.get(value);
    }

    public static KupeIndication convertKupeIndicationFromGds(Integer gdsValue) {
        return (KupeIndication)CollectionUtil.getKeyByValue(kupeIndicationMap, (Object)gdsValue);
    }

    public static String convertGenderToGds(Gender value) {
        return genderMap.get(value);
    }

    public static Gender convertGenderFromGds(String gdsValue) {
        return (Gender)CollectionUtil.getKeyByValue(genderMap, (Object)gdsValue);
    }

    public static String convertPassportTypeToGds(PassportType value) {
        return passportTypeMap.get(value);
    }

    public static PassportType convertPassportTypeFromGds(String gdsValue) {
        return (PassportType)CollectionUtil.getKeyByValue(passportTypeMap, (Object)gdsValue);
    }

    public static String convertTariffToGds(RzdTariff value) {
        return tariffsMap.get(value);
    }

    public static RzdTariff convertTariffFromGds(String gdsValue) {
        return (RzdTariff)CollectionUtil.getKeyByValue(tariffsMap, (Object)gdsValue);
    }

    public static String convertPassengerTypeToGds(DictionaryReference<PassengerType> value) {
        PassengerTypeValue ptv = DictHelper.getPassengerTypeValue(value);
        String[] arr = passengerTypeMap.get(ptv);
        return arr == null ? null : arr[0];
    }

    public static DictionaryReference<PassengerType> convertPassengerTypeFromGds(String gdsValue) {
        if (gdsValue == null) {
            return null;
        }
        for (Map.Entry<PassengerTypeValue, String[]> entry : passengerTypeMap.entrySet()) {
            String[] arr;
            PassengerTypeValue ptv = entry.getKey();
            for (String enValue : arr = entry.getValue()) {
                if (!enValue.equals(gdsValue.trim())) continue;
                PassengerType pt = (PassengerType)DictHelper.getPredifinedValue((DictPredifinedValueProvider)ptv);
                return pt.toReference();
            }
        }
        return DictHelper.getAdultPassengerType();
    }

    public static MovementDirection convertMovementDirectionFromGds(String gdsValue) {
        return (MovementDirection)CollectionUtil.getKeyByValue(movementDirectionMap, (Object)gdsValue);
    }

    public static String convertContentTypeToGds(ContentType value) {
        return contentTypeMap.get(value);
    }

    public static ContentType convertDocumentTypeFromGds(String gdsValue) {
        return (ContentType)CollectionUtil.getKeyByValue(contentTypeMap, (Object)gdsValue);
    }

    public static void fillRefundBlankPriceVatInfo(RefundTransactionInfo.BlankPrice bp, BlankInfo refBlankInfo) {
        bp.setTariffVat(refBlankInfo.getTariffReturnNds());
        bp.setTariffVatRate(refBlankInfo.getTariffRateNds());
        bp.setServiceVat(refBlankInfo.getServiceReturnNds());
        bp.setServiceVatRate(refBlankInfo.getServiceRateNds());
        bp.setPenaltyVat(refBlankInfo.getReclamationCollectReturnNds());
        bp.setPenaltyVatRate(refBlankInfo.getReclamationCollectRateNds());
    }

    static {
        carriageTypeMap.put(CarriageType.O, "\u041e");
        carriageTypeMap.put(CarriageType.S, "\u0421");
        carriageTypeMap.put(CarriageType.P, "\u041f");
        carriageTypeMap.put(CarriageType.K, "\u041a");
        carriageTypeMap.put(CarriageType.M, "\u041c");
        carriageTypeMap.put(CarriageType.L, "\u041b");
        compartmentTypeMap = new HashMap<CompartmentType, String>();
        compartmentTypeMap.put(CompartmentType.MEN, "\u041c");
        compartmentTypeMap.put(CompartmentType.WOMEN, "\u0416");
        compartmentTypeMap.put(CompartmentType.COMMON, "\u0421");
        kupeIndicationMap = new HashMap<KupeIndication, Integer>();
        kupeIndicationMap.put(KupeIndication.ANY, 0);
        kupeIndicationMap.put(KupeIndication.ONE_KUPE, 1);
        kupeIndicationMap.put(KupeIndication.ANY_KUPE, 2);
        kupeIndicationMap.put(KupeIndication.ONE_SECTION, 3);
        genderMap = new HashMap<Gender, String>();
        genderMap.put(Gender.FEMALE, "F");
        genderMap.put(Gender.MALE, "M");
        passportTypeMap = new HashMap<PassportType, String>();
        passportTypeMap.put(PassportType.INTERNAL, "\u041f\u041d");
        passportTypeMap.put(PassportType.BIRTHDAY_NOTIFICATION, "\u0421\u0420");
        passportTypeMap.put(PassportType.PASSPORT, "\u0417\u0417");
        passportTypeMap.put(PassportType.FOREIGN, "\u0417\u041f");
        passportTypeMap.put(PassportType.SEAMANSID, "\u041f\u041c");
        passportTypeMap.put(PassportType.MILITARYID, "\u0412\u0411");
        passportTypeMap.put(PassportType.IDENTITYCARD, "\u0423\u041b");
        tariffsMap = new HashMap<RzdTariff, String>();
        tariffsMap.put(RzdTariff.FULL, "1");
        tariffsMap.put(RzdTariff.CHILD, "2");
        tariffsMap.put(RzdTariff.BABY, "3");
        tariffsMap.put(RzdTariff.SENIOR_SAPSAN, "4");
        tariffsMap.put(RzdTariff.SENIOR, "5");
        tariffsMap.put(RzdTariff.JUNIOR, "6");
        tariffsMap.put(RzdTariff.CHILD_12, "7");
        tariffsMap.put(RzdTariff.INFANT_4, "8");
        tariffsMap.put(RzdTariff.CHILD_17, "9");
        tariffsMap.put(RzdTariff.INFANT_6, "10");
        tariffsMap.put(RzdTariff.CHILD_7, "11");
        tariffsMap.put(RzdTariff.INFANT_10, "12");
        tariffsMap.put(RzdTariff.CHILD_10_17, "13");
        tariffsMap.put(RzdTariff.SCHOOL, "14");
        tariffsMap.put(RzdTariff.INFANT_12, "15");
        tariffsMap.put(RzdTariff.INFANT_6_MKL11, "16");
        tariffsMap.put(RzdTariff.JUNIOR_10_21, "17");
        tariffsMap.put(RzdTariff.CHILD_KTZ, "1002");
        tariffsMap.put(RzdTariff.INFANT_KTZ, "1003");
        passengerTypeMap = new HashMap<PassengerTypeValue, String[]>();
        passengerTypeMap.put(PassengerTypeValue.ADULT, new String[]{"adult_doc", "\u041f\u041e\u041b\u041d\u042b\u0419", "\u0414\u0415\u042217", "\u0428\u041a", "\u042e\u041d\u0418\u041e\u0420", "60+", "72 ADULT", "71 \u0412\u0417\u0420/\u0410DUL\u0422", "71 ADULT", "86 12-26/JUNIOR", "78 60+/SENIOR"});
        passengerTypeMap.put(PassengerTypeValue.CHILD, new String[]{"child_doc", "\u0414\u0415\u0422", "73 CHILD", "77 \u0414\u0415\u0422\u0418/\u041aIND", "77 CHILD"});
        passengerTypeMap.put(PassengerTypeValue.INFANT, new String[]{"baby_doc", "\u0411\u0415\u0417\u0414\u0415\u041d\u0415\u0416\u041d\u042b\u0419 \u0414\u0415\u0422\u0421\u041a\u0418\u0419 \u0414\u0415\u04225", "\u0411\u0415\u0417\u0414\u0415\u041d\u0415\u0416\u041d\u042b\u0419 \u0414\u0415\u0422\u0421\u041a\u0418\u0419 \u0414\u041e\u041f\u041f", "50 \u0414\u0415\u0422\u0418/\u041aIND 0+", "50 CHILD 0+"});
        movementDirectionMap = new HashMap<MovementDirection, String>();
        movementDirectionMap.put(MovementDirection.FORWARD, "forward");
        movementDirectionMap.put(MovementDirection.OPPOSITE, "opposite");
        contentTypeMap = new HashMap<ContentType, String>();
        contentTypeMap.put(ContentType.HTML, "html");
        contentTypeMap.put(ContentType.PDF, "pdf");
    }
}

