/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.ufs.checkReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.ufs.IBusUfsContextKeys;
import com.gridnine.xtrip.server.ibecorp.ufs.model.TransInfoResponse;
import com.gridnine.xtrip.server.ibecorp.ufs.model.domain.BlankInfo;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;

public class UfsReservationCheckSellTransInfoDataProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        boolean rzdStatusChanged;
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        TransInfoResponse response = (TransInfoResponse)ctx.getMandatoryObject((Enum)IBusUfsContextKeys.UFS_TRANS_INFO_RESPONSE);
        ArrayList<String> stanChangedTickets = new ArrayList<String>();
        ArrayList<String> rzdStatusChangedTickets = new ArrayList<String>();
        for (BlankInfo bi : response.getBlanks()) {
            RailwayProduct rp = RzdCommonHelper.getSellProductByBlankId((Reservation)reservation, (String)bi.getBlankId());
            if (rp == null) continue;
            if (!bi.isRefund() && !TextUtil.isBlank((String)rp.getRefundStan())) {
                rp.setRefundStan(null);
                stanChangedTickets.add(rp.getSystemNumber());
            }
            if (TextUtil.isBlank((String)rp.getRefundStan()) && bi.getRzdStatus() == RzdStatus.REFUND) {
                bi.setRzdStatus(RzdStatus.PLACES_REFUND);
            }
            if (rp.getIbecorpRzdStatus() == bi.getRzdStatus()) continue;
            rp.setIbecorpRzdStatus(bi.getRzdStatus());
            rzdStatusChangedTickets.add(rp.getSystemNumber());
        }
        if (!stanChangedTickets.isEmpty()) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0421\u0432\u0435\u0440\u043a\u0430 \u0437\u0430\u043a\u0430\u0437\u0430: \u041e\u0431\u0443\u043d\u0443\u043b\u0438\u043b\u0441\u044f RefundStan \u0434\u043b\u044f \u0431\u0438\u043b\u0435\u0442\u043e\u0432 {0}", (Object[])new Object[]{stanChangedTickets}));
        }
        boolean bl = rzdStatusChanged = !rzdStatusChangedTickets.isEmpty();
        if (rzdStatusChanged) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0421\u0432\u0435\u0440\u043a\u0430 \u0437\u0430\u043a\u0430\u0437\u0430: \u0418\u0437\u043c\u0435\u043d\u0438\u043b\u0441\u044f RzdStatus \u0434\u043b\u044f \u0431\u0438\u043b\u0435\u0442\u043e\u0432 {0}", (Object[])new Object[]{rzdStatusChangedTickets}));
        }
        ctx.putObject((Enum)IBusRailwayContextKeys.RAILWAY_TICKET_STATUS_CHANGED, (Object)rzdStatusChanged);
    }
}

