/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.ufs.checkReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdStatus;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationStatus;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.ufs.IBusUfsContextKeys;
import com.gridnine.xtrip.server.ibecorp.ufs.model.TransInfoResponse;
import com.gridnine.xtrip.server.ibecorp.ufs.model.domain.BlankInfo;
import com.gridnine.xtrip.server.ibus.components.BaseRoutingKeyProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;

public class UfsReservationStatusProvider
extends BaseRoutingKeyProvider {
    public String getRoutingKey(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        TransInfoResponse response = (TransInfoResponse)ctx.getMandatoryObject((Enum)IBusUfsContextKeys.UFS_TRANS_INFO_RESPONSE);
        ProductStatus status = this.calcStatus(response);
        ctx.putObject((Enum)IBusRailwayContextKeys.RAILWAY_PRODUCT_STATUS, (Object)status);
        if (status == null) {
            reservation.setStatus(ReservationStatus.ERROR);
        }
        return status == null ? null : status.name();
    }

    private ProductStatus calcStatus(TransInfoResponse response) {
        if (response.getTransInfo().gettStatusType() == null) {
            return null;
        }
        if (this.isBookingRzhdStatuses(response)) {
            return ProductStatus.BOOKING;
        }
        switch (response.getTransInfo().gettStatusType()) {
            case PROCESS: {
                return ProductStatus.BOOKING;
            }
            case UNSUCCESS: {
                return ProductStatus.VOID_BOOKING;
            }
            case SUCCESS: {
                return this.existsRefund(response) ? ProductStatus.REFUND : ProductStatus.SELL;
            }
        }
        return null;
    }

    private boolean isBookingRzhdStatuses(TransInfoResponse response) {
        for (BlankInfo bi : response.getBlanks()) {
            if (bi.getRzdStatus() == RzdStatus.NOT_CONFIRMED) continue;
            return false;
        }
        return true;
    }

    private boolean existsRefund(TransInfoResponse response) {
        for (BlankInfo bi : response.getBlanks()) {
            if (!bi.isRefund()) continue;
            return true;
        }
        return false;
    }
}

