/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.ufs.createReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.AgeRestriction;
import com.gridnine.xtrip.common.ibecorp.model.RzdReservationCreationParameters;
import com.gridnine.xtrip.common.ibecorp.model.RzdTraveller;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTariff;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.common.createReservation.RzdReservationCreationParametersValidator;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class RailwayUpdatePassengerTypeProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        RzdReservationCreationParameters params = (RzdReservationCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        List travellers = (List)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLERS);
        this.updatePassengerTypes(params, travellers);
    }

    private void updatePassengerTypes(RzdReservationCreationParameters params, List<Traveller> travellers) {
        Collection<RzdTariff> tariffs = RzdReservationCreationParametersValidator.getAvailableTariffs(params);
        if (params.getRzdTravellers().size() > 1 && tariffs.contains(RzdTariff.INFANT_10)) {
            Iterator it = params.getRzdTravellers().iterator();
            it.next();
            while (it.hasNext()) {
                RzdTraveller rzdTraveller = (RzdTraveller)it.next();
                if (!DictHelper.isAdultPassengerType((DictionaryReference)rzdTraveller.getPassengerType())) continue;
                Traveller traveller = (Traveller)CollectionUtil.find(travellers, (String)rzdTraveller.getTravellerUid());
                Date birthDate = traveller.getPassport().getBirthday();
                AgeRestriction ageRestriction = new AgeRestriction(null, null, Integer.valueOf(10), Boolean.FALSE);
                ArrayList messages = new ArrayList();
                Date departureDate = params.getSegment().getTrain().getDepartureDatetime();
                ageRestriction.validate(birthDate, departureDate, messages);
                if (!messages.isEmpty()) continue;
                rzdTraveller.setTariff(RzdTariff.INFANT_10);
                rzdTraveller.setPassengerType(DictHelper.getChildPassengerType());
            }
        }
    }
}

