/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.ufs.createReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.PlacingRequirements;
import com.gridnine.xtrip.common.ibecorp.model.RzdReservationCreationParameters;
import com.gridnine.xtrip.common.ibecorp.model.RzdTraveller;
import com.gridnine.xtrip.common.ibecorp.model.UfsGdsAccount;
import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdBookingSegmentParams;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdPrice;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTariff;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.railway.CarriageType;
import com.gridnine.xtrip.common.model.booking.railway.CompartmentType;
import com.gridnine.xtrip.common.model.booking.railway.ServiceClass;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.RailwayBonusCard;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.ibecorp.RzdHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.RailwayHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.ufs.IBusUfsContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.ufs.UfsHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.ufs.UfsRequestParameters;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.ufs.UfsRequestUrlSuffix;
import com.gridnine.xtrip.server.ibecorp.ufs.util.UfsUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.railway.model.helpers.RzdServiceConverter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UfsBuyTicketPostXmlRequestBuilder
extends BaseProcessor {
    private static List<RzdTariff> withoutBirthdayTariffs = Arrays.asList(RzdTariff.FULL, RzdTariff.CHILD, RzdTariff.BABY);

    public void process(MessageContext ctx) throws Exception {
        RzdReservationCreationParameters params = (RzdReservationCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        Customer customer = (Customer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.CUSTOMER);
        List travellers = (List)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLERS);
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        ctx.putObject((Enum)IBusUfsContextKeys.UFS_REQUEST_PARAMETERS, (Object)new UfsRequestParameters(UfsRequestUrlSuffix.BuyTicketPostXml, this.buildRequestData(params, customer, travellers, (UfsGdsAccount)accountCtr.getEntity())));
    }

    private String buildRequestData(RzdReservationCreationParameters params, Customer customer, List<Traveller> travellers, UfsGdsAccount gdsAccount) throws Exception {
        Element dataEl = this.buildRequestDataEl(params, customer, travellers, gdsAccount);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("input", XUtil.toString((Element)dataEl));
        return UfsHelper.generateDatafromMap(map, "UTF-8");
    }

    private Element buildRequestDataEl(RzdReservationCreationParameters params, Customer customer, List<Traveller> travellers, UfsGdsAccount gdsAccount) throws Exception {
        Document doc = DocumentBuilderHelper.newDocument();
        Element root = doc.createElement("BuyTicket");
        doc.appendChild(root);
        this.addDirection(root, params.getSegment());
        this.addPassengers(root, params, travellers);
        this.addPlacingRequirements(root, params.getSegment());
        CompartmentType gender = params.getSegment().getPlacing().getGender();
        if (gender != null) {
            XHelper.writeString((Element)root, (String)"Sex", (String)UfsHelper.convertCompartmentTypeToGds(gender));
        }
        XHelper.writeString((Element)root, (String)"placedemands", (String)RailwayHelper.calcPlaceDemands(params.getSegment()));
        XHelper.writeString((Element)root, (String)"terminal", (String)gdsAccount.getTerminal());
        XHelper.writeInt((Element)root, (String)"RemoteCheckIn", (Integer)UfsHelper.booleanToInt(params.getSegment().getRzdCar().isERegEnabled()));
        XHelper.writeString((Element)root, (String)"lang", (String)"Ru");
        return root;
    }

    private void addDirection(Element parentEl, RzdBookingSegmentParams params) {
        Document doc = parentEl.getOwnerDocument();
        Element el = doc.createElement("Direction");
        parentEl.appendChild(el);
        XHelper.writeString((Element)el, (String)"from", (String)params.getTrain().getPassengerFrom().getCode());
        XHelper.writeString((Element)el, (String)"to", (String)params.getTrain().getPassengerTo().getCode());
        XHelper.writeString((Element)el, (String)"train", (String)params.getRzdPrice().getTrainNumber());
        if (params.getRzdPrice().getCategory() != null) {
            XHelper.writeString((Element)el, (String)"type_car", (String)UfsHelper.convertCarriageTypeToGds(params.getRzdPrice().getCategory()));
        }
        XHelper.writeString((Element)el, (String)"day", (String)UfsUtil.getDayFromDate(params.getTrain().getDepartureDatetime()));
        XHelper.writeString((Element)el, (String)"month", (String)UfsUtil.getMonthFromDate(params.getTrain().getDepartureDatetime()));
        XHelper.writeString((Element)el, (String)"time", (String)UfsUtil.getTimeFromDate(params.getTrain().getDepartureDatetime()));
        XHelper.writeString((Element)el, (String)"n_car", (String)params.getRzdCar().getNumber());
        if (params.getRzdPrice().getServiceClass() != null) {
            XHelper.writeString((Element)el, (String)"service_class", (String)RzdServiceConverter.getServiceClassName((ServiceClass)params.getRzdPrice().getServiceClass()));
        }
        if (!TextUtil.isBlank((String)params.getRzdPrice().getInternationalServiceClass())) {
            XHelper.writeString((Element)el, (String)"internationalServiceClass", (String)params.getRzdPrice().getInternationalServiceClass());
        }
    }

    private void addPassengers(Element parentEl, RzdReservationCreationParameters params, List<Traveller> travellers) {
        Document doc = parentEl.getOwnerDocument();
        Element elPassengers = doc.createElement("Passengers");
        parentEl.appendChild(elPassengers);
        for (RzdTraveller rzdTraveller : params.getRzdTravellers()) {
            Traveller traveller = (Traveller)CollectionUtil.find(travellers, (String)rzdTraveller.getTravellerUid());
            Passport passport = traveller.getPassport();
            Element el = doc.createElement("Passenger");
            elPassengers.appendChild(el);
            XHelper.writeString((Element)el, (String)"passType", (String)UfsHelper.convertPassengerTypeToGds((DictionaryReference<PassengerType>)rzdTraveller.getPassengerType()));
            XHelper.writeString((Element)el, (String)"doc", (String)String.format("%s%s", UfsHelper.convertPassportTypeToGds(passport.getType()), passport.getNumber()));
            XHelper.writeString((Element)el, (String)"fio", (String)String.format("%s=%s=%s", RzdHelper.modifyNameForGds(passport.getLastName()), RzdHelper.modifyNameForGds(passport.getFirstName()), RzdHelper.modifyNameForGds(passport.getMiddleName(), true)));
            if (passport.getBirthday() != null) {
                XHelper.writeString((Element)el, (String)"birthdate", (String)this.buildBirthDateValue(passport.getBirthday(), rzdTraveller.getTariff()));
            } else {
                XHelper.writeString((Element)el, (String)"birthdate", (String)RzdHelper.getEmptyValue());
            }
            Country country = (Country)DictionaryCache.get().resolveReference(passport.getCitizenship());
            if (country != null) {
                String countryCode = DictHelper.getCodeVariant((BaseDictionary)country, (CodeSystem)CodeSystem.EXPRESS);
                if (TextUtil.isBlank((String)countryCode)) {
                    throw Xeption.forEndUser((String)"\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a \u0441\u0442\u0440\u0430\u043d \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043a\u043e\u0434 \u0434\u043b\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f ({0})", (Object[])new Object[]{country.getCode()});
                }
                XHelper.writeString((Element)el, (String)"citizenship", (String)countryCode);
            } else {
                XHelper.writeString((Element)el, (String)"citizenship", (String)RzdHelper.getEmptyValue());
            }
            if (passport.getGender() != null) {
                XHelper.writeString((Element)el, (String)"sex", (String)UfsHelper.convertGenderToGds(passport.getGender()));
            } else {
                XHelper.writeString((Element)el, (String)"sex", (String)RzdHelper.getEmptyValue());
            }
            RailwayBonusCard bonusCard = traveller.getRailwayBonusCard();
            if (bonusCard != null && !TextUtil.isBlank((String)bonusCard.getNumber())) {
                XHelper.writeString((Element)el, (String)"bonuscard", (String)bonusCard.getNumber());
            }
            if (!RzdCommonHelper.isNK1((RzdPrice)params.getSegment().getRzdPrice())) continue;
            XHelper.writeInt((Element)el, (String)"numberkupe", (int)1);
        }
    }

    private String buildBirthDateValue(Date birthday, RzdTariff tariff) {
        StringBuilder sb = new StringBuilder();
        sb.append(new SimpleDateFormat("ddMMyyyy").format(birthday));
        if (tariff != null && !withoutBirthdayTariffs.contains(tariff)) {
            sb.append("*").append(UfsHelper.convertTariffToGds(tariff));
        }
        return sb.toString();
    }

    private void addPlacingRequirements(Element parentEl, RzdBookingSegmentParams params) {
        CarriageType carriageType;
        PlacingRequirements plReq = params.getPlacing();
        Document doc = parentEl.getOwnerDocument();
        Element el = doc.createElement("PlacingRequirements");
        parentEl.appendChild(el);
        if (plReq.getSeatRangeFirst() != null && plReq.getSeatRangeLast() != null) {
            XHelper.writeString((Element)el, (String)"diapason", (String)String.format("%d-%d", plReq.getSeatRangeFirst(), plReq.getSeatRangeLast()));
        }
        if ((carriageType = params.getRzdPrice().getCategory()) != CarriageType.S && carriageType != CarriageType.O) {
            XHelper.writeInt((Element)el, (String)"n_up", (Integer)plReq.getUpperSeatsCount());
            XHelper.writeInt((Element)el, (String)"n_down", (Integer)plReq.getLowerSeatsCount());
        }
        if (plReq.getKupeIndication() != null) {
            XHelper.writeInt((Element)el, (String)"in_one_kupe", (Integer)UfsHelper.convertKupeIndicationToGds(plReq.getKupeIndication()));
        }
        if (plReq.getWithBedding() != null) {
            XHelper.writeInt((Element)el, (String)"bedding", (Integer)UfsHelper.booleanToInt(plReq.getWithBedding()));
        }
    }
}

