/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.ufs.createReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.RzdReservationCreationParameters;
import com.gridnine.xtrip.common.ibecorp.model.RzdTraveller;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdBookingSegmentParams;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdGdsParameters;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTariff;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.railway.CarriageType;
import com.gridnine.xtrip.common.model.booking.railway.CompartmentType;
import com.gridnine.xtrip.common.model.booking.railway.ServiceClass;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.dict.Principal;
import com.gridnine.xtrip.common.model.dict.railway.RailwayCarrier;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.RzdHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.RailwayHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.common.createReservation.RzdReservationCreationWrapperParamsAbstractProvider;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.common.createReservation.RzdReservationCreationWrapperProvider;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.ufs.IBusUfsContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.ufs.UfsHelper;
import com.gridnine.xtrip.server.ibecorp.ufs.util.UfsUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.railway.model.helpers.RzdServiceConverter;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public class UfsBuyTicketPostXmlResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        RzdGdsParameters gdsParams = (RzdGdsParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        RzdReservationCreationParameters params = (RzdReservationCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        RzdBookingSegmentParams segmentParams = (RzdBookingSegmentParams)ctx.getMandatoryObject((Enum)IBusRailwayContextKeys.RAILWAY_BOOKING_SEGMENT_PARAMS);
        List travellers = (List)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLERS);
        Element responseEl = (Element)ctx.getMandatoryObject((Enum)IBusUfsContextKeys.UFS_RESPONSE_DATA);
        EntityReference supplierRef = (EntityReference)ctx.getObject((Enum)IBusRailwayContextKeys.RAILWAY_SUPPLIER_REF);
        Date trainDepartureDate = (Date)ctx.getObject((Enum)IBusRailwayContextKeys.RAILWAY_TRAIN_DEPARTURE_DATE);
        PaymentType paymentType = (PaymentType)ctx.getObject((Enum)IBusGdsContextKeys.PAYMENT_TYPE);
        ctx.putObject((Enum)IBusRailwayContextKeys.RAILWAY_CREATE_RESERVATION_PARAMETERS, (Object)this.buildCreateReservationParams(gdsParams, salesContext, params, segmentParams, travellers, (EntityReference<Organization>)supplierRef, responseEl, trainDepartureDate, paymentType));
    }

    private RzdReservationCreationWrapperProvider buildCreateReservationParams(RzdGdsParameters gdsParams, SalesContext salesContext, RzdReservationCreationParameters params, RzdBookingSegmentParams segmentParams, List<Traveller> travellers, EntityReference<Organization> supplier, final Element responseEl, final Date trainDepartureDate, final PaymentType paymentType) throws Exception {
        final Date createDate = new SimpleDateFormat("ddMMyy HHmm").parse(XHelper.readString((Element)responseEl, (String)"D2") + " " + XHelper.readString((Element)responseEl, (String)"TB"));
        final Date timelimit = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").parse(XHelper.readString((Element)responseEl, (String)"ConfirmTimeLimit"));
        RzdReservationCreationWrapperParamsAbstractProvider result = new RzdReservationCreationWrapperParamsAbstractProvider(salesContext, params, segmentParams, gdsParams, travellers, supplier){

            @Override
            public String getRecordLocator() {
                return XHelper.readString((Element)responseEl, (String)"IDTrans");
            }

            @Override
            public Date getCreateDate() {
                return createDate;
            }

            @Override
            public Date getTimelimit() {
                return timelimit;
            }

            @Override
            public Date getTrainDepartureDate() {
                return trainDepartureDate;
            }

            @Override
            public CarriageType getCarriageType() {
                return UfsHelper.convertCarriageTypeFromGds(XHelper.readString((Element)responseEl, (String)"KV"));
            }

            @Override
            public DictionaryReference<RailwayStation> getDepartureStation() {
                return RzdHelper.getStationRefByCode(XHelper.readString((Element)responseEl, (String)"CC1"));
            }

            @Override
            public DictionaryReference<RailwayStation> getArriveStation() {
                return RzdHelper.getStationRefByCode(XHelper.readString((Element)responseEl, (String)"CC2"));
            }

            @Override
            public Date getDepartureDate() {
                String dt = XHelper.readString((Element)responseEl, (String)"D3");
                String tm = XHelper.readString((Element)responseEl, (String)"T1");
                return UfsUtil.calcDate(dt, tm);
            }

            @Override
            public Date getArriveDate() {
                String dt = XHelper.readString((Element)responseEl, (String)"D1");
                String tm = XHelper.readString((Element)responseEl, (String)"T4");
                return UfsUtil.calcDate(dt, tm);
            }

            @Override
            public String getTrainNumber() {
                return XHelper.readString((Element)responseEl, (String)"N1");
            }

            @Override
            public String getCarriageNumber() {
                return XHelper.readString((Element)responseEl, (String)"VH");
            }

            @Override
            public CompartmentType getCompartmentType() {
                return UfsHelper.convertCompartmentTypeFromGds(XHelper.readString((Element)responseEl, (String)"R"));
            }

            @Override
            public ServiceClass getServiceClass() {
                return RzdServiceConverter.getServiceClassByName((String)XHelper.readString((Element)responseEl, (String)"KL"));
            }

            @Override
            public DictionaryReference<RailwayCarrier> getCarrier() {
                return RzdHelper.getCarrier(XHelper.readString((Element)responseEl, (String)"PER"), XHelper.readString((Element)responseEl, (String)"INN"), this.getLogInfoAboutTrain());
            }

            @Override
            public String getComfortInfo() {
                return XHelper.readString((Element)responseEl, (String)"R0");
            }

            @Override
            public String getTimeInfo() {
                return XHelper.readString((Element)responseEl, (String)"GB");
            }

            @Override
            public String getAddInfo() {
                return XHelper.readString((Element)responseEl, (String)"GA");
            }

            @Override
            public String getTrainCategory() {
                return XHelper.readString((Element)responseEl, (String)"KN1");
            }

            @Override
            public List<RzdReservationCreationWrapperProvider.PassengerParamsProvider> getPassengers() {
                ArrayList<RzdReservationCreationWrapperProvider.PassengerParamsProvider> psgrParams = new ArrayList<RzdReservationCreationWrapperProvider.PassengerParamsProvider>();
                Element[] tickedtsElements = XmlUtil.getElements((Element)responseEl, (String)"ET");
                ArrayList pairs = new ArrayList();
                for (Element ticketsEl : tickedtsElements) {
                    for (Element pEl : XmlUtil.getElements((Element)ticketsEl, (String)"PI")) {
                        String birthdateStr;
                        Passport p = new Passport();
                        String[] names = XHelper.readString((Element)pEl, (String)"IZ").split("=");
                        p.setLastName(names[0]);
                        if (names.length > 1) {
                            p.setFirstName(names[1]);
                            if (names.length > 2) {
                                p.setMiddleName(names[2]);
                            }
                        }
                        if (!TextUtil.isBlank((String)(birthdateStr = XHelper.readString((Element)pEl, (String)"GD")))) {
                            try {
                                p.setBirthday(new SimpleDateFormat("ddMMyyyy").parse(birthdateStr));
                            }
                            catch (ParseException e) {
                                UfsBuyTicketPostXmlResponseParser.this.log.error("fail parse birthdate " + birthdateStr);
                            }
                        }
                        this.fillDocumentNumber(XHelper.readString((Element)pEl, (String)"PS"), p);
                        pairs.add(MiscUtil.Pair.of((Object)pEl, (Object)p));
                    }
                }
                Map travellersMap = RzdHelper.buildPassportTravellersMap(pairs, this.travellers);
                for (final Element ticketsEl : tickedtsElements) {
                    final BigDecimal totalVat = XHelper.readBigDecimal((Element)ticketsEl, (String)"TF4");
                    final BigDecimal serviceVat = XHelper.readBigDecimal((Element)ticketsEl, (String)"TF5");
                    for (Element pEl : XmlUtil.getElements((Element)ticketsEl, (String)"PI")) {
                        final Traveller traveller = travellersMap.get(pEl);
                        final RzdTraveller rzdTraveller = RailwayHelper.getRzdTraveller(traveller.getUid(), this.params.getRzdTravellers());
                        psgrParams.add(new RzdReservationCreationWrapperProvider.PassengerParamsProvider(){

                            @Override
                            public Traveller getTraveller() {
                                return traveller;
                            }

                            @Override
                            public String getBlankId() {
                                return XHelper.readString((Element)ticketsEl, (String)"IDBlank");
                            }

                            @Override
                            public RzdTariff getTariff() {
                                return rzdTraveller.getTariff();
                            }

                            @Override
                            public BigDecimal getPrice() {
                                return XHelper.readBigDecimal((Element)ticketsEl, (String)"TF");
                            }

                            @Override
                            public DictionaryReference<PassengerType> getPassengerType() {
                                return UfsHelper.convertPassengerTypeFromGds(XHelper.readString((Element)ticketsEl, (String)"GT"));
                            }

                            @Override
                            public String getSeatNumber() {
                                return XHelper.readString((Element)ticketsEl, (String)"H");
                            }

                            @Override
                            public PaymentType getPaymentType() {
                                return paymentType;
                            }

                            @Override
                            public BigDecimal getEquivalentVat() {
                                return totalVat == null ? null : totalVat.subtract(MiscUtil.guarded((BigDecimal)serviceVat));
                            }

                            @Override
                            public BigDecimal getServiceVat() {
                                return serviceVat;
                            }

                            @Override
                            public Double getEquivalentVatRate() {
                                return XHelper.readDouble((Element)ticketsEl, (String)"STV1", (double)0.0);
                            }

                            @Override
                            public Double getServiceVatRate() {
                                return XHelper.readDouble((Element)ticketsEl, (String)"STV2", (double)0.0);
                            }

                            @Override
                            public BigDecimal getReservedSeatFare() {
                                return null;
                            }

                            @Override
                            public BigDecimal getSegmentFare() {
                                return null;
                            }

                            @Override
                            public DictionaryReference<Principal> getPrincipal() {
                                return null;
                            }
                        });
                    }
                }
                return psgrParams;
            }

            private void fillDocumentNumber(String doc, Passport p) {
                if (TextUtil.isBlank((String)doc)) {
                    return;
                }
                PassportType docType = null;
                String docNumber = null;
                for (PassportType pt : PassportType.values()) {
                    String gdsDocType = UfsHelper.convertPassportTypeToGds(pt);
                    if (gdsDocType == null || !doc.startsWith(gdsDocType)) continue;
                    docType = pt;
                    docNumber = doc.substring(gdsDocType.length());
                    break;
                }
                p.setType(docType);
                p.setNumber(docNumber);
            }
        };
        return result;
    }
}

