/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.ufs.createReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.PlacingRequirements;
import com.gridnine.xtrip.common.ibecorp.model.RzdReservationCreationParameters;
import com.gridnine.xtrip.common.ibecorp.model.RzdTraveller;
import com.gridnine.xtrip.common.ibecorp.model.UfsGdsAccount;
import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdBookingSegmentParams;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTariff;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTrain;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.railway.CarriageType;
import com.gridnine.xtrip.common.model.booking.railway.ServiceClass;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.RailwayBonusCard;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.ibecorp.RzdHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.RailwayHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.ufs.IBusUfsContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.ufs.UfsHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.ufs.UfsRequestParameters;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.ufs.UfsRequestUrlSuffix;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.railway.model.helpers.RzdServiceConverter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UfsBuyTicketXmlRequestBuilder
extends BaseProcessor {
    private static final String SEGMENT_TYPE_RAILWAY_THERE = "RailwayThere";
    private static final String SEGMENT_TYPE_RAILWAY_BACK = "RailwayBack";

    public void process(MessageContext ctx) throws Exception {
        RzdReservationCreationParameters params = (RzdReservationCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        Customer customer = (Customer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.CUSTOMER);
        List travellers = (List)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLERS);
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        ctx.putObject((Enum)IBusUfsContextKeys.UFS_REQUEST_PARAMETERS, (Object)new UfsRequestParameters(UfsRequestUrlSuffix.BuyTicketXml, this.buildRequestData(params, travellers), this.buildUrlParameters((UfsGdsAccount)accountCtr.getEntity())));
    }

    private Map<String, String> buildUrlParameters(UfsGdsAccount gdsAccount) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("terminal", gdsAccount.getTerminal());
        return result;
    }

    private String buildRequestData(RzdReservationCreationParameters params, List<Traveller> travellers) throws Exception {
        Element dataEl = this.buildRequestDataEl(params, travellers);
        return XUtil.toString((Element)dataEl);
    }

    private Element buildRequestDataEl(RzdReservationCreationParameters params, List<Traveller> travellers) throws Exception {
        Document doc = DocumentBuilderHelper.newDocument();
        Element root = doc.createElement("BookingXml");
        doc.appendChild(root);
        root.setAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
        root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        int remoteCheckIn = params.getSegmentBack() == null ? UfsHelper.booleanToInt(params.getSegment().getRzdCar().isERegEnabled()) : 2;
        boolean isOnePassenger = this.isOnePassenger(travellers);
        boolean isFullCompartmentCase = this.isFullCompartmentCase(params, isOnePassenger);
        List<Traveller> requestTravellers = isFullCompartmentCase ? this.getUniqueTravellers(travellers) : travellers;
        this.updateStationsCodes(params);
        Element elSegments = doc.createElement("Segments");
        root.appendChild(elSegments);
        this.addSegment(elSegments, params.getSegment(), SEGMENT_TYPE_RAILWAY_THERE, remoteCheckIn, isOnePassenger);
        if (params.getSegmentBack() != null) {
            this.addSegment(elSegments, params.getSegmentBack(), SEGMENT_TYPE_RAILWAY_BACK, remoteCheckIn, isOnePassenger);
        }
        this.addPassengers(root, params, requestTravellers);
        XHelper.writeString((Element)root, (String)"PayType", (String)"CASH");
        XHelper.writeString((Element)root, (String)"Language", (String)"RU");
        return root;
    }

    private boolean isOnePassenger(List<Traveller> travellers) {
        Passport passport = null;
        for (Traveller traveller : travellers) {
            if (passport == null) {
                passport = traveller.getPassport();
                continue;
            }
            if (RzdCommonHelper.isSamePassports((Passport)passport, (Passport)traveller.getPassport(), (boolean)true)) continue;
            return false;
        }
        return true;
    }

    private boolean isFullCompartmentCase(RzdReservationCreationParameters params, boolean isOnePassenger) {
        Integer segmentFullCompartmentValue = this.getIsFullCompartmentValue(params.getSegment(), isOnePassenger);
        if (params.getSegmentBack() == null) {
            return segmentFullCompartmentValue != null;
        }
        Integer segmentBackFullCompartmentValue = this.getIsFullCompartmentValue(params.getSegmentBack(), isOnePassenger);
        return segmentFullCompartmentValue != null && segmentBackFullCompartmentValue != null;
    }

    private List<Traveller> getUniqueTravellers(List<Traveller> travellers) {
        ArrayList<Traveller> result = new ArrayList<Traveller>();
        for (Traveller traveller : travellers) {
            if (RzdHelper.findTravellerByPassport(traveller.getPassport(), result) != null) continue;
            result.add(traveller);
        }
        return result;
    }

    private void updateStationsCodes(RzdReservationCreationParameters params) {
        DictionaryReference<RailwayStation> cityStationRef;
        if (params.getSegmentBack() == null) {
            return;
        }
        RzdTrain train = params.getSegment().getTrain();
        RzdTrain trainBack = params.getSegmentBack().getTrain();
        if (!train.getPassengerFrom().equals((Object)trainBack.getPassengerTo()) && (cityStationRef = this.getCommonCityStation((DictionaryReference<RailwayStation>)train.getPassengerFrom(), (DictionaryReference<RailwayStation>)trainBack.getPassengerTo())) != null) {
            train.setPassengerFrom(cityStationRef);
            trainBack.setPassengerTo(cityStationRef);
        }
        if (!train.getPassengerTo().equals((Object)trainBack.getPassengerFrom()) && (cityStationRef = this.getCommonCityStation((DictionaryReference<RailwayStation>)train.getPassengerTo(), (DictionaryReference<RailwayStation>)trainBack.getPassengerFrom())) != null) {
            train.setPassengerTo(cityStationRef);
            trainBack.setPassengerFrom(cityStationRef);
        }
    }

    private DictionaryReference<RailwayStation> getCommonCityStation(DictionaryReference<RailwayStation> stationRef1, DictionaryReference<RailwayStation> stationRef2) {
        DictionaryReference<RailwayStation> cityStation1 = RailwayHelper.getCityStation(stationRef1);
        if (cityStation1 == null) {
            return null;
        }
        DictionaryReference<RailwayStation> cityStation2 = RailwayHelper.getCityStation(stationRef2);
        return cityStation1.equals(cityStation2) ? cityStation1 : null;
    }

    private void addSegment(Element parentEl, RzdBookingSegmentParams params, String segmentType, int remoteCheckIn, boolean isOnePassenger) {
        CarriageType carriageType;
        PlacingRequirements plReq;
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");
        SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm");
        Document doc = parentEl.getOwnerDocument();
        Element el = doc.createElement("BookSegmentXml");
        parentEl.appendChild(el);
        XHelper.writeString((Element)el, (String)"FromStation", (String)params.getTrain().getPassengerFrom().getCode());
        XHelper.writeString((Element)el, (String)"ToStation", (String)params.getTrain().getPassengerTo().getCode());
        XHelper.writeString((Element)el, (String)"DepartureDate", (String)dateFormat.format(params.getTrain().getDepartureDatetime()));
        XHelper.writeString((Element)el, (String)"DepartureTime", (String)timeFormat.format(params.getTrain().getDepartureDatetime()));
        XHelper.writeString((Element)el, (String)"TrainNumber", (String)params.getRzdPrice().getTrainNumber());
        XHelper.writeString((Element)el, (String)"CarNumber", (String)params.getRzdCar().getNumber());
        if (params.getRzdPrice().getCategory() != null) {
            XHelper.writeString((Element)el, (String)"Type", (String)UfsHelper.convertCarriageTypeToGds(params.getRzdPrice().getCategory()));
        }
        if (params.getRzdPrice().getServiceClass() != null) {
            XHelper.writeString((Element)el, (String)"ServiceClass", (String)RzdServiceConverter.getServiceClassName((ServiceClass)params.getRzdPrice().getServiceClass()));
        }
        if (!TextUtil.isBlank((String)params.getRzdPrice().getInternationalServiceClass())) {
            XHelper.writeString((Element)el, (String)"InternationalServiceClass", (String)params.getRzdPrice().getInternationalServiceClass());
        }
        if ((plReq = params.getPlacing()).getGender() != null) {
            XHelper.writeString((Element)el, (String)"Gender", (String)UfsHelper.convertCompartmentTypeToGds(params.getPlacing().getGender()));
        }
        if (plReq.getSeatRangeFirst() != null && plReq.getSeatRangeLast() != null) {
            XHelper.writeString((Element)el, (String)"Diapason", (String)String.format("%d-%d", plReq.getSeatRangeFirst(), plReq.getSeatRangeLast()));
        }
        if ((carriageType = params.getRzdPrice().getCategory()) != CarriageType.S && carriageType != CarriageType.O) {
            XHelper.writeInt((Element)el, (String)"NumberOfUp", (Integer)plReq.getUpperSeatsCount());
            XHelper.writeInt((Element)el, (String)"NumberOfDown", (Integer)plReq.getLowerSeatsCount());
        }
        if (plReq.getKupeIndication() != null) {
            XHelper.writeInt((Element)el, (String)"PlaceRequirements", (Integer)UfsHelper.convertKupeIndicationToGds(plReq.getKupeIndication()));
        }
        if (plReq.getWithBedding() != null) {
            XHelper.writeInt((Element)el, (String)"WithOutBedding", (Integer)UfsHelper.booleanToInt(plReq.getWithBedding() == false));
        }
        XHelper.writeString((Element)el, (String)"PlaceDemands", (String)RailwayHelper.calcPlaceDemands(params));
        XHelper.writeInt((Element)el, (String)"RemoteCheckIn", (int)remoteCheckIn);
        XHelper.writeString((Element)el, (String)"SegmentType", (String)segmentType);
        Integer isFullCompartmentValue = this.getIsFullCompartmentValue(params, isOnePassenger);
        if (isFullCompartmentValue != null) {
            XHelper.writeInt((Element)el, (String)"IsFullCompartment", (Integer)isFullCompartmentValue);
        }
    }

    private Integer getIsFullCompartmentValue(RzdBookingSegmentParams params, boolean isOnePassenger) {
        if (!(params.getPlacing().isOneKupeAllSeats() && params.getRzdPrice().isFullKupe() && isOnePassenger)) {
            return null;
        }
        switch (params.getRzdPrice().getCategory()) {
            case K: {
                return 1;
            }
            case L: {
                return 2;
            }
        }
        return null;
    }

    private void addPassengers(Element parentEl, RzdReservationCreationParameters params, List<Traveller> travellers) {
        Document doc = parentEl.getOwnerDocument();
        Element elPassengers = doc.createElement("Passengers");
        parentEl.appendChild(elPassengers);
        for (RzdTraveller rzdTraveller : params.getRzdTravellers()) {
            Traveller traveller = (Traveller)CollectionUtil.find(travellers, (String)rzdTraveller.getTravellerUid());
            if (traveller == null) continue;
            Passport passport = traveller.getPassport();
            Element el = doc.createElement("PassengerXml");
            elPassengers.appendChild(el);
            XHelper.writeString((Element)el, (String)"DocumentType", (String)UfsHelper.convertPassportTypeToGds(passport.getType()));
            XHelper.writeString((Element)el, (String)"DocumentNumber", (String)passport.getNumber());
            XHelper.writeString((Element)el, (String)"LastName", (String)RzdHelper.modifyNameForGds(passport.getLastName()));
            XHelper.writeString((Element)el, (String)"FirstName", (String)RzdHelper.modifyNameForGds(passport.getFirstName()));
            XHelper.writeString((Element)el, (String)"MiddleName", (String)RzdHelper.modifyNameForGds(passport.getMiddleName(), true));
            if (passport.getBirthday() != null) {
                XHelper.writeString((Element)el, (String)"DateOfBirth", (String)new SimpleDateFormat("dd.MM.yyyy").format(passport.getBirthday()));
            } else {
                XHelper.writeString((Element)el, (String)"DateOfBirth", (String)RzdHelper.getEmptyValue());
            }
            Country country = (Country)DictionaryCache.get().resolveReference(passport.getCitizenship());
            if (country != null) {
                String countryCode = DictHelper.getCodeVariant((BaseDictionary)country, (CodeSystem)CodeSystem.EXPRESS);
                if (TextUtil.isBlank((String)countryCode)) {
                    throw Xeption.forEndUser((String)"\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a \u0441\u0442\u0440\u0430\u043d \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043a\u043e\u0434 \u0434\u043b\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f ({0})", (Object[])new Object[]{country.getCode()});
                }
                XHelper.writeString((Element)el, (String)"Citizenship", (String)countryCode);
            } else {
                XHelper.writeString((Element)el, (String)"Citizenship", (String)RzdHelper.getEmptyValue());
            }
            if (passport.getGender() != null) {
                XHelper.writeString((Element)el, (String)"Gender", (String)UfsHelper.convertGenderToGds(passport.getGender()));
            } else {
                XHelper.writeString((Element)el, (String)"Gender", (String)RzdHelper.getEmptyValue());
            }
            RailwayBonusCard bonusCard = traveller.getRailwayBonusCard();
            if (DictHelper.isAdultPassengerType((DictionaryReference)rzdTraveller.getPassengerType()) && bonusCard != null && !TextUtil.isBlank((String)bonusCard.getNumber())) {
                this.addBonusCard(el, bonusCard.getNumber());
            }
            this.addTariffs(el, rzdTraveller.getTariff(), SEGMENT_TYPE_RAILWAY_THERE);
            if (params.getSegmentBack() == null) continue;
            this.addTariffs(el, rzdTraveller.getTariff(), SEGMENT_TYPE_RAILWAY_BACK);
        }
    }

    private void addBonusCard(Element parentEl, String cardNumber) {
        Document doc = parentEl.getOwnerDocument();
        Element el = doc.createElement("PassengerCard");
        parentEl.appendChild(el);
        XHelper.writeString((Element)el, (String)"CardType", (String)"BonusCard");
        XHelper.writeString((Element)el, (String)"Number", (String)cardNumber);
    }

    private void addTariffs(Element parentEl, RzdTariff tariff, String segmentType) {
        Document doc = parentEl.getOwnerDocument();
        Element tariffsEl = doc.createElement("Tariffs");
        parentEl.appendChild(tariffsEl);
        Element el = doc.createElement("PassengerTariffXml");
        tariffsEl.appendChild(el);
        XHelper.writeString((Element)el, (String)"SegmentType", (String)segmentType);
        XHelper.writeString((Element)el, (String)"TariffCode", (String)UfsHelper.convertTariffToGds(tariff));
    }
}

