/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.ufs.getTrainRoute;

import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdRoute;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdRoutePoint;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.ufs.IBusUfsContextKeys;
import com.gridnine.xtrip.server.ibecorp.ufs.model.domain.RouteInfo;
import com.gridnine.xtrip.server.ibecorp.ufs.response.Util;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

public class UfsTrainRouteResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Element responseEl = (Element)ctx.getMandatoryObject((Enum)IBusUfsContextKeys.UFS_RESPONSE_DATA);
        ctx.putObject((Enum)IBusRailwayContextKeys.RAILWAY_TRAIN_ROUTES, this.buildRoutes(responseEl));
    }

    private List<RzdRoute> buildRoutes(Element root) {
        ArrayList<RzdRoute> result = new ArrayList<RzdRoute>();
        for (Element elRoute : XmlUtil.getElements((Element)root, (String)"S/A")) {
            RzdRoute route = new RzdRoute();
            route.setTitle(XHelper.readString((Element)elRoute, (String)"AA"));
            RouteInfo routeInfo = Util.readRouteInfo(elRoute, "AP");
            route.setDeparture(routeInfo.getDeparture());
            route.setArrival(routeInfo.getArrival());
            for (Element elPoint : XmlUtil.getElements((Element)elRoute, (String)"AC")) {
                RzdRoutePoint point = new RzdRoutePoint();
                point.setStationName(XHelper.readString((Element)elPoint, (String)"C"));
                point.setStationCode(XHelper.readString((Element)elPoint, (String)"C1"));
                point.setArrivalTime(XHelper.readString((Element)elPoint, (String)"T6"));
                point.setStopTime(Duration.ofMinutes(XHelper.readInt((Element)elPoint, (String)"T2").intValue()));
                point.setDepartureTime(XHelper.readString((Element)elPoint, (String)"T7"));
                route.getPoints().add(point);
            }
            result.add(route);
        }
        return result;
    }
}

