/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.ufs.getTrainSeats;

import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdCar;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdGetTrainSeatsParameters;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdGetTrainSeatsResult;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdPrice;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdPriceValues;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTariff;
import com.gridnine.xtrip.common.model.booking.railway.CarriageType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.ufs.IBusUfsContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.ufs.UfsHelper;
import com.gridnine.xtrip.server.ibecorp.ufs.model.domain.Carriage;
import com.gridnine.xtrip.server.ibecorp.ufs.response.Util;
import com.gridnine.xtrip.server.ibecorp.ufs.util.UfsUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.railway.model.helpers.RzdServiceConverter;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Element;

public class UfsCarListExResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        RzdGetTrainSeatsParameters params = (RzdGetTrainSeatsParameters)ctx.getMandatoryObject((Enum)IBusRailwayContextKeys.RAILWAY_GET_TRAIN_SEATS_PARAMETERS);
        Element responseEl = (Element)ctx.getMandatoryObject((Enum)IBusUfsContextKeys.UFS_RESPONSE_DATA);
        ctx.putObject((Enum)IBusRailwayContextKeys.RAILWAY_GET_TRAIN_SEATS_RESULT, (Object)this.buildResult(responseEl, params));
    }

    private RzdGetTrainSeatsResult buildResult(Element root, RzdGetTrainSeatsParameters params) {
        RzdGetTrainSeatsResult result = new RzdGetTrainSeatsResult();
        Integer directionGroup = XHelper.readInt((Element)root, (String)"S/Z3/PP/DirectionGroup");
        for (Element elTrain : XmlUtil.getElements((Element)root, (String)"S/N")) {
            result.setAddInfo(XHelper.readString((Element)elTrain, (String)"GA"));
            for (Element elCK : XmlUtil.getElements((Element)elTrain, (String)"CK")) {
                RzdPrice price = this.buildPrice(elCK, elTrain, directionGroup, params);
                if (price == null) continue;
                result.getPrices().add(price);
            }
        }
        return result;
    }

    private RzdPrice buildPrice(Element el, Element elTrain, Integer directionGroup, RzdGetTrainSeatsParameters params) {
        CarriageType carriageType = UfsHelper.convertCarriageTypeFromGds(XHelper.readString((Element)el, (String)"KV"));
        if (carriageType == null) {
            return null;
        }
        RzdPrice price = new RzdPrice();
        price.setCategory(carriageType);
        price.setCategoryTitle(XHelper.readString((Element)el, (String)"KV1"));
        price.getAvailableTariffs().addAll(this.buildAvailableTariffs(XHelper.readString((Element)el, (String)"AvailableTariffs")));
        price.setFullKupe(UfsHelper.existsAsTrue(el, "FullKupe"));
        BigDecimal tariff = XHelper.readBigDecimal((Element)el, (String)"TF");
        BigDecimal tariff2 = XHelper.readBigDecimal((Element)el, (String)"TF2");
        BigDecimal serv = XHelper.readBigDecimal((Element)el, (String)"TF3");
        this.setPrices(price, tariff, tariff2, serv);
        price.setSubcategory(XHelper.readString((Element)el, (String)"R"));
        String serviceClassStr = XHelper.readString((Element)el, (String)"CO");
        price.setServiceClassAbbr(serviceClassStr);
        price.setServiceClass(RzdServiceConverter.getServiceClassByName((String)serviceClassStr));
        price.setServiceDescription(XHelper.readString((Element)el, (String)"CO_DESC"));
        price.setServiceList(MiscUtil.guarded((String)XHelper.readString((Element)el, (String)"CO_SRV")));
        price.setSeatsIncluded(UfsHelper.existsAsTrue(el, "DM") ? 2 : (UfsHelper.existsAsTrue(el, "QM") ? 4 : 1));
        price.setRoute(XHelper.readString((Element)el, (String)"W2"));
        price.setWithDiscount(UfsHelper.existsAsTrue(el, "Discount"));
        price.setInternationalServiceClass(XHelper.readString((Element)el, (String)"MKL"));
        price.setTrainName(XHelper.readString((Element)elTrain, (String)"BRN"));
        String trainNumber = XHelper.readString((Element)elTrain, (String)"N1");
        price.setTrainNumber(trainNumber);
        price.setDepartureDatetime(UfsUtil.calcDate(XHelper.readString((Element)elTrain, (String)"D"), XHelper.readString((Element)elTrain, (String)"T1")));
        Date trainArrivalDateTime = UfsUtil.calcDate(XHelper.readString((Element)elTrain, (String)"D1"), XHelper.readString((Element)elTrain, (String)"T4"));
        price.setDirectionGroup(directionGroup);
        price.getCars().addAll(this.parseCars(el, trainNumber, trainArrivalDateTime));
        return price;
    }

    private RzdCar toRzdCar(Element elCar, String trainNumber, Date trainArrivalDt) {
        RzdCar car = this.parseCar(elCar);
        car.setTrainNumber(trainNumber);
        if (car.getArrivalDatetime() == null) {
            car.setArrivalDatetime(trainArrivalDt);
        }
        return car;
    }

    private List<RzdCar> parseCars(Element el, String trainNumber, Date trainArrivalDt) {
        return Stream.of(XmlUtil.getElements((Element)el, (String)"CV")).map(carElement -> this.toRzdCar((Element)carElement, trainNumber, trainArrivalDt)).collect(Collectors.toList());
    }

    private Set<RzdTariff> buildAvailableTariffs(String gdsValue) {
        if (TextUtil.isBlank((String)gdsValue)) {
            return Collections.emptySet();
        }
        List gdsTariffs = TextUtil.split((String)gdsValue, (String)";", (boolean)true, (boolean)true);
        Set<RzdTariff> result = gdsTariffs.stream().map(UfsHelper::convertTariffFromGds).filter(Objects::nonNull).collect(Collectors.toSet());
        return result;
    }

    private RzdCar parseCar(Element el) {
        RzdCar car = new RzdCar();
        car.setNumber(XHelper.readString((Element)el, (String)"VH"));
        Carriage carriage = new Carriage();
        Util.fillCarriage(el, carriage);
        String places = XHelper.readString((Element)el, (String)"H");
        car.setUndefinedCount(MiscUtil.guarded((Integer)carriage.getUndefinedCount()).intValue());
        car.setLowerCount(MiscUtil.guarded((Integer)carriage.getLowerCount()).intValue());
        car.setUpperCount(MiscUtil.guarded((Integer)carriage.getUpperCount()).intValue());
        car.setLowerSideCount(MiscUtil.guarded((Integer)carriage.getLowerSideCount()).intValue());
        car.setUpperSideCount(MiscUtil.guarded((Integer)carriage.getUpperSideCount()).intValue());
        car.setMaleCount(StringUtils.countMatches((String)places, (String)"\u041c") + StringUtils.countMatches((String)places, (String)"\u0426"));
        car.setFemaleCount(StringUtils.countMatches((String)places, (String)"\u0416") + StringUtils.countMatches((String)places, (String)"\u0426"));
        car.setMixedCount(StringUtils.countMatches((String)places, (String)"\u0421") + StringUtils.countMatches((String)places, (String)"\u0426"));
        car.setERegEnabled(UfsHelper.existsAsTrue(el, "ER"));
        car.setTwoStoreyed(UfsHelper.existsAsTrue(el, "TwoStorey"));
        car.setBeddingEnabled(UfsHelper.existsAsTrue(el, "BL"));
        car.setSchema(XHelper.readString((Element)el, (String)"SCHEMA"));
        car.getVacantSeats().addAll(this.convertSeatsToStringList(XHelper.readString((Element)el, (String)"H")));
        String routeDescription = XHelper.readString((Element)el, (String)"AA");
        if (!TextUtil.isBlank((String)routeDescription)) {
            car.setTrailerCar(routeDescription.contains("\u0411\u041f"));
            car.setArrivalDatetime(UfsUtil.calcDate(XHelper.readString((Element)el, (String)"D1"), XHelper.readString((Element)el, (String)"T4")));
        }
        return car;
    }

    private void setPrices(RzdPrice price, BigDecimal tariff1, BigDecimal tariff2, BigDecimal serv) {
        BigDecimal minTariff = MiscUtil.guarded((BigDecimal)tariff1);
        BigDecimal maxTariff = MiscUtil.guarded((BigDecimal)tariff2);
        if (BigDecimal.ZERO.compareTo(maxTariff) == 0) {
            maxTariff = minTariff;
        }
        price.setPrice(this.createPriceValues(minTariff, maxTariff, serv));
    }

    private RzdPriceValues setPriceValues(BigDecimal serv, BigDecimal minTariff, BigDecimal maxTariff) {
        RzdPriceValues pv = new RzdPriceValues();
        BigDecimal guardedServ = MiscUtil.guarded((BigDecimal)serv);
        pv.setOriginal(maxTariff.subtract(guardedServ));
        pv.setOriginalMin(minTariff.subtract(guardedServ));
        return pv;
    }

    private RzdPriceValues createPriceValues(BigDecimal minTariff, BigDecimal maxTariff, BigDecimal serv) {
        RzdPriceValues pv = new RzdPriceValues();
        pv.setOriginal(maxTariff);
        pv.setOriginalMin(minTariff);
        pv.setServiceCost(serv);
        return pv;
    }

    private List<String> convertSeatsToStringList(String value) {
        if (value == null) {
            return Collections.emptyList();
        }
        return TextUtil.split((String)value, (String)",", (boolean)true, (boolean)true);
    }
}

