/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.ufs.getTransList;

import com.gridnine.xtrip.common.ibecorp.model.UfsGdsAccount;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.gds.GdsAccountIndex;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.assets.UfsTransListAsset;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.ufs.IBusUfsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class UfsCollectGdsAccountsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        List<EntityContainer<UfsGdsAccount>> gdsAccounts = this.getGdsAccounts();
        if (gdsAccounts.isEmpty()) {
            ctx.putObject((Enum)IBusUfsContextKeys.UFS_GDS_ACCOUNTS, Collections.emptyMap());
            return;
        }
        Date endDate = MiscUtil.addDaysToDate((Date)MiscUtil.clearTime((Date)new Date()), (int)-1);
        Date startDate = MiscUtil.addDaysToDate((Date)endDate, (int)-30);
        Map datesByGdsAccounts = gdsAccounts.stream().collect(Collectors.toMap(Function.identity(), gdsAccount -> this.getNotLoadedDates((EntityContainer<UfsGdsAccount>)gdsAccount, startDate, endDate)));
        datesByGdsAccounts.values().removeIf(List::isEmpty);
        ctx.putObject((Enum)IBusUfsContextKeys.UFS_GDS_ACCOUNTS, datesByGdsAccounts);
    }

    private List<EntityContainer<UfsGdsAccount>> getGdsAccounts() {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)GdsAccountIndex.Property.gds.name(), (Object)GdsName.UFS));
        return EntityStorage.get().search(GdsAccountIndex.class, query).getData().stream().filter(index -> index.getSource() != null && UfsGdsAccount.class.equals((Object)index.getSource().getType())).map(index -> index.getSource()).map(arg_0 -> ((EntityStorage)EntityStorage.get()).resolve(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private List<Date> getNotLoadedDates(EntityContainer<UfsGdsAccount> gdsAccount, Date startDate, Date endDate) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)UfsTransListAsset.Property.gdsAccount.name(), (Object)gdsAccount.toReference()));
        query.getCriteria().getCriterions().add(SearchCriterion.between((String)UfsTransListAsset.Property.date.name(), (Object)startDate, (Object)endDate));
        query.getPreferredProperties().add(UfsTransListAsset.Property.date.name());
        List loadedDates = AssetsStorage.get().search(UfsTransListAsset.class, query).getData().stream().map(UfsTransListAsset::getDate).map(MiscUtil::clearTime).collect(Collectors.toList());
        ArrayList<Date> notLoadedDates = new ArrayList<Date>();
        Date currentDate = startDate;
        while (currentDate.before(endDate) || currentDate.equals(endDate)) {
            if (!loadedDates.contains(currentDate)) {
                notLoadedDates.add(currentDate);
            }
            currentDate = MiscUtil.addDaysToDate((Date)currentDate, (int)1);
        }
        return notLoadedDates;
    }
}

