/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.ufs.getTransList;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.UfsGdsAccount;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.assets.UfsTransListAsset;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.ufs.IBusUfsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class UfsGetLoadedTransIdsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer gdsAccount = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        Date startDate = (Date)ctx.getMandatoryObject((Enum)IBusUfsContextKeys.UFS_START_DATE);
        Date endDate = (Date)ctx.getMandatoryObject((Enum)IBusUfsContextKeys.UFS_END_DATE);
        startDate = MiscUtil.clearTime((Date)startDate);
        endDate = MiscUtil.clearTime((Date)endDate);
        List<String> transIds = this.getLoadedTransIds((EntityContainer<UfsGdsAccount>)gdsAccount, startDate, endDate);
        ctx.putObject((Enum)IBusUfsContextKeys.UFS_TRANS_ID_LIST, transIds);
    }

    private List<String> getLoadedTransIds(EntityContainer<UfsGdsAccount> gdsAccount, Date startDate, Date endDate) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)UfsTransListAsset.Property.gdsAccount.name(), (Object)gdsAccount.toReference()));
        query.getCriteria().getCriterions().add(SearchCriterion.between((String)UfsTransListAsset.Property.date.name(), (Object)startDate, (Object)MiscUtil.setDayEndTime((Date)endDate)));
        query.getPreferredProperties().add(UfsTransListAsset.Property.date.name());
        query.getPreferredProperties().add(UfsTransListAsset.Property.transactionIds.name());
        SortedMap transIdsByDate = AssetsStorage.get().search(UfsTransListAsset.class, query).getData().stream().collect(Collectors.toMap(asset -> MiscUtil.clearTime((Date)asset.getDate()), UfsTransListAsset::getTransactionIds, (first, second) -> {
            ArrayList result = new ArrayList(first);
            result.addAll(second);
            return result;
        }, TreeMap::new));
        Date currentDate = startDate;
        while (currentDate.before(endDate) || currentDate.equals(endDate)) {
            if (!transIdsByDate.containsKey(currentDate)) {
                throw Xeption.forEndUser((String)"\u041d\u0435 \u0431\u044b\u043b \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d \u0441\u043f\u0438\u0441\u043e\u043a \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0439 \u0423\u0424\u0421 \u0434\u043b\u044f \u0434\u0430\u0442\u044b {0} \u0438 \u043b\u043e\u0433\u0438\u043d\u0430 {1}", (Object[])new Object[]{new SimpleDateFormat("dd.MM.yyyy").format(currentDate), ((UfsGdsAccount)gdsAccount.getEntity()).getAccount()});
            }
            currentDate = MiscUtil.addDaysToDate((Date)currentDate, (int)1);
        }
        return transIdsByDate.values().stream().flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }
}

