/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.ufs.getTransList;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.UfsGdsAccount;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.assets.UfsTransListAsset;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.ufs.IBusUfsContextKeys;
import com.gridnine.xtrip.server.ibecorp.ufs.model.TransListResponse;
import com.gridnine.xtrip.server.ibecorp.ufs.model.domain.TransInfo;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class UfsSaveTransListIdsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer gdsAccount = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        Date date = (Date)ctx.getMandatoryObject((Enum)IBusUfsContextKeys.UFS_DATE);
        TransListResponse transListResponse = (TransListResponse)ctx.getMandatoryObject((Enum)IBusUfsContextKeys.UFS_TRANS_LIST_RESPONSE);
        List transactionIds = transListResponse.getTrans().stream().map(TransInfo::getIdTrans).filter(TextUtil::nonBlank).distinct().collect(Collectors.toList());
        UfsTransListAsset asset = new UfsTransListAsset();
        asset.setModified(new Date());
        asset.setGdsAccount((EntityReference<UfsGdsAccount>)gdsAccount.toReference());
        asset.setDate(date);
        asset.getTransactionIds().clear();
        asset.getTransactionIds().addAll(transactionIds);
        AssetsStorage.get().save((BaseAsset)asset);
    }
}

