/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.ufs.searchSchedule;

import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdAbstractSearchParameters;
import com.gridnine.xtrip.common.ibecorp.rzd.model.ScheduleTrain;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.ufs.IBusUfsContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.ufs.UfsHelper;
import com.gridnine.xtrip.server.ibecorp.ufs.model.domain.RouteInfo;
import com.gridnine.xtrip.server.ibecorp.ufs.response.Util;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Element;

public class UfsTimeTableResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Element responseEl = (Element)ctx.getMandatoryObject((Enum)IBusUfsContextKeys.UFS_RESPONSE_DATA);
        RzdAbstractSearchParameters params = (RzdAbstractSearchParameters)ctx.getMandatoryObject((Enum)IBusRailwayContextKeys.RAILWAY_SEARCH_SCHEDULE_PARAMETERS);
        ctx.putObject((Enum)IBusRailwayContextKeys.RAILWAY_SCHEDULE_TRAINS, this.buildScheduleTrains(responseEl, params.getDepartureDate()));
    }

    private List<ScheduleTrain> buildScheduleTrains(Element root, Date departureDate) throws Exception {
        ArrayList<ScheduleTrain> result = new ArrayList<ScheduleTrain>();
        for (Element el : XmlUtil.getElements((Element)root, (String)"S/N")) {
            result.add(this.buildScheduleTrain(el, departureDate));
        }
        return result;
    }

    private ScheduleTrain buildScheduleTrain(Element el, Date departureDate) throws Exception {
        ScheduleTrain result = new ScheduleTrain();
        result.setGds(GdsName.UFS);
        result.setTrainNumber(XHelper.readString((Element)el, (String)"N1"));
        result.setTrainTitle(XHelper.readString((Element)el, (String)"NN"));
        RouteInfo routeInfo = Util.readRouteInfo(el, "NP");
        result.setTrainDeparture(routeInfo.getDeparture());
        result.setTrainArrival(routeInfo.getArrival());
        Integer wayTimeSeconds = UfsHelper.convertToSeconds(XHelper.readString((Element)el, (String)"T3"));
        result.setDepartureDate(UfsHelper.addTimeToDate(departureDate, XHelper.readString((Element)el, (String)"T1")));
        if (wayTimeSeconds == null) {
            result.setArrivalDate(UfsHelper.addTimeToDate(departureDate, XHelper.readString((Element)el, (String)"T4")));
        } else {
            result.setArrivalDate(MiscUtil.addMinutesToDate((Date)result.getDepartureDate(), (int)(wayTimeSeconds / 60)));
        }
        result.setWayTime(wayTimeSeconds);
        result.setTimetable(XHelper.readString((Element)el, (String)"J/DW"));
        return result;
    }
}

