/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.ufs.searchTrains;

import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdCategory;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTrain;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTrainWithCategories;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.railway.CarriageType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.Pair;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.ibecorp.RzdHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.ufs.UfsHelper;
import com.gridnine.xtrip.server.ibecorp.ufs.model.domain.Carriage;
import com.gridnine.xtrip.server.ibecorp.ufs.model.domain.RouteInfo;
import com.gridnine.xtrip.server.ibecorp.ufs.response.Util;
import com.gridnine.xtrip.server.ibecorp.ufs.util.UfsUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.w3c.dom.Element;

public class TrainListParser {
    private Element response;
    private List<RzdTrainWithCategories> resultList = new ArrayList<RzdTrainWithCategories>();
    private DictionaryReference<RailwayStation> defaultFromStation;
    private DictionaryReference<RailwayStation> defaultToStation;
    private Function<String, DictionaryReference<RailwayStation>> stationResolver = code -> RzdHelper.getStationRefByCode(code);
    private List<PassportType> passportTypes = new ArrayList<PassportType>();

    public void setStationResolver(Function<String, DictionaryReference<RailwayStation>> stationResolver) {
        this.stationResolver = stationResolver;
    }

    public List<RzdTrainWithCategories> buildTrains(Element root) throws Exception {
        this.response = root;
        this.readStations();
        this.readPassportTypes();
        for (Element element : XmlUtil.getElements((Element)this.response, (String)"S/N")) {
            this.readTrainWithCategories(element);
        }
        return this.resultList;
    }

    private void readStations() {
        this.defaultFromStation = this.stationResolver.apply(XHelper.readString((Element)this.response, (String)"S/Z3/PP/FromCode"));
        this.defaultToStation = this.stationResolver.apply(XHelper.readString((Element)this.response, (String)"S/Z3/PP/ToCode"));
    }

    private void readPassportTypes() {
        String gdsPassportTypesStr = XHelper.readString((Element)this.response, (String)"S/Z3/PP/AllowedDocTypes");
        if (TextUtil.isBlank((String)gdsPassportTypesStr)) {
            return;
        }
        for (String value : TextUtil.split((String)gdsPassportTypesStr, (String)",", (boolean)true, (boolean)true)) {
            PassportType passportType = UfsHelper.convertPassportTypeFromGds(value);
            if (passportType == null) continue;
            this.passportTypes.add(passportType);
        }
    }

    private void readTrainWithCategories(Element trainElement) throws Exception {
        HashSet<Pair<String>> categoriesVOKs = new HashSet<Pair<String>>();
        RzdTrainWithCategories result = new RzdTrainWithCategories();
        result.setTrain(this.buildTrain(trainElement));
        for (Element categoryElement : XmlUtil.getElements((Element)trainElement, (String)"CK")) {
            RzdCategory category = this.buildCategory(categoryElement, categoriesVOKs);
            if (category == null) continue;
            result.getCategories().add(category);
        }
        this.processCategoryVOKs(result.getTrain(), categoriesVOKs);
        this.resultList.add(result);
    }

    private void processCategoryVOKs(RzdTrain train, Set<Pair<String>> categoriesVOKs) {
        if (categoriesVOKs.isEmpty()) {
            return;
        }
        if (categoriesVOKs.size() > 1) {
            throw Xeption.forDeveloper((String)"different VOKs values in one train", (Object[])new Object[0]);
        }
        Pair<String> voksValues = categoriesVOKs.iterator().next();
        if (!TextUtil.isBlank((String)((String)voksValues.getFirst()))) {
            train.setPassengerFrom(this.stationResolver.apply((String)voksValues.getFirst()));
        }
        if (!TextUtil.isBlank((String)((String)voksValues.getLast()))) {
            train.setPassengerTo(this.stationResolver.apply((String)voksValues.getLast()));
        }
    }

    private RzdTrain buildTrain(Element el) {
        RzdTrain train = new RzdTrain();
        train.setNumber(XHelper.readString((Element)el, (String)"N1"));
        train.setDisplayNumber(XHelper.readString((Element)el, (String)"N2"));
        train.setCategory(XHelper.readString((Element)el, (String)"KN"));
        train.setBrand(XHelper.readString((Element)el, (String)"BRN"));
        this.setTrainDates(el, train);
        train.setDepartureDatetime(UfsUtil.calcDate(XHelper.readString((Element)el, (String)"D"), XHelper.readString((Element)el, (String)"T1")));
        train.setArrivalDatetime(UfsUtil.calcDate(XHelper.readString((Element)el, (String)"D1"), XHelper.readString((Element)el, (String)"T4")));
        train.setWayTime(Integer.valueOf(UfsHelper.convertToSeconds(XHelper.readString((Element)el, (String)"T3")) / 60));
        train.setERegEnabled(UfsHelper.existsAsTrue(el, "ER"));
        train.getPassportTypes().addAll(this.passportTypes);
        train.setPassengerFrom(this.readPassengerFrom(el));
        train.setPassengerTo(this.readPassengerTo(el));
        return train;
    }

    private void setTrainDates(Element el, RzdTrain train) {
        RouteInfo routeInfo = Util.readRouteInfo(el, "NP");
        train.setDeparture(routeInfo.getDeparture());
        train.setArrival(routeInfo.getArrival());
    }

    private DictionaryReference<RailwayStation> readPassengerTo(Element el) {
        String code = XHelper.readString((Element)el, (String)"VOK/C2");
        if (!TextUtil.isBlank((String)code)) {
            return this.stationResolver.apply(code);
        }
        return this.defaultToStation;
    }

    private DictionaryReference<RailwayStation> readPassengerFrom(Element el) {
        String code = XHelper.readString((Element)el, (String)"VOK/C1");
        if (!TextUtil.isBlank((String)code)) {
            return this.stationResolver.apply(code);
        }
        return this.defaultFromStation;
    }

    private Pair<String> readVokTag(Element element) {
        return new Pair((Object)XHelper.readString((Element)element, (String)"VOK/C1"), (Object)XHelper.readString((Element)element, (String)"VOK/C2"));
    }

    private RzdCategory buildCategory(Element categoryElement, Set<Pair<String>> categoriesVoks) {
        CarriageType carriageType = UfsHelper.convertCarriageTypeFromGds(XHelper.readString((Element)categoryElement, (String)"KV"));
        if (carriageType == null) {
            return null;
        }
        RzdCategory category = new RzdCategory();
        category.setCarriageType(carriageType);
        category.setWithDiscount(UfsHelper.existsAsTrue(categoryElement, "Discount"));
        category.setRoute(XHelper.readString((Element)categoryElement, (String)"W2"));
        List<Carriage> ufsCVs = this.buildUfsCarriages(categoryElement);
        category.setSeatsCount(Integer.valueOf(this.calculateCategorySeatCount(ufsCVs)));
        category.setSubcategory(XHelper.readString((Element)categoryElement, (String)"R"));
        this.collectCategoryVok(categoryElement, categoriesVoks);
        return category;
    }

    private void collectCategoryVok(Element categoryElement, Set<Pair<String>> categoriesVoks) {
        Pair<String> vokTag = this.readVokTag(categoryElement);
        if (!TextUtil.isBlank((String)((String)vokTag.getFirst())) || !TextUtil.isBlank((String)((String)vokTag.getLast()))) {
            categoriesVoks.add(vokTag);
        }
    }

    private List<Carriage> buildUfsCarriages(Element el) {
        ArrayList<Carriage> result = new ArrayList<Carriage>();
        for (Element elVS : XmlUtil.getElements((Element)el, (String)"CV")) {
            Carriage carriage = new Carriage();
            Util.fillCarriage(elVS, carriage);
            result.add(carriage);
        }
        return result;
    }

    private int calculateCategorySeatCount(List<Carriage> ufsCVs) {
        int result = 0;
        for (Carriage car : ufsCVs) {
            result += MiscUtil.guarded((Integer)car.getUndefinedCount()).intValue();
            result += MiscUtil.guarded((Integer)car.getLowerCount()).intValue();
            result += MiscUtil.guarded((Integer)car.getUpperCount()).intValue();
            result += MiscUtil.guarded((Integer)car.getLowerSideCount()).intValue();
            result += MiscUtil.guarded((Integer)car.getUpperSideCount()).intValue();
        }
        return result;
    }
}

